/*
 * Decompiled with CFR 0.152.
 */
package me.tobystrong.compactstorage.block;

import java.util.List;
import java.util.UUID;
import me.tobystrong.compactstorage.CompactStorage;
import me.tobystrong.compactstorage.block.tile.CompactChestTileEntity;
import me.tobystrong.compactstorage.util.CompactStorageUtilMethods;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CompactChestBlock
extends ContainerBlock
implements IWaterLoggable {
    public static EnumProperty<Direction> PROPERTY_FACING = EnumProperty.func_177706_a((String)"facing", Direction.class, (Enum[])new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST});
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public CompactChestBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(2.0f, 5.0f).harvestLevel(1).harvestTool(ToolType.PICKAXE).func_226896_b_().func_200947_a(SoundType.field_185852_e));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(PROPERTY_FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (worldIn.func_180495_p(pos.func_177982_a(0, 1, 0)).func_200132_m()) {
            return ActionResultType.FAIL;
        }
        ItemStack heldItem = player.func_184586_b(handIn);
        if (heldItem.func_77973_b() == CompactStorage.upgrade_column || heldItem.func_77973_b() == CompactStorage.upgrade_row) {
            TileEntity entity = worldIn.func_175625_s(pos);
            if (entity != null && worldIn instanceof ServerWorld) {
                ServerWorld serverWorld = (ServerWorld)worldIn;
                CompactChestTileEntity chestTile = (CompactChestTileEntity)entity;
                CompactStorageUtilMethods.UpgradeStatus status = chestTile.handleUpgradeItem(heldItem);
                if (status == CompactStorageUtilMethods.UpgradeStatus.SUCCESS) {
                    serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197632_y, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 5, 0.25, 0.0, 0.25, 0.0);
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187802_ec, SoundCategory.BLOCKS, 0.25f, 1.0f);
                    worldIn.func_184138_a(pos, state, state, 2);
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(handIn).func_190920_e(heldItem.func_190916_E() - 1);
                    }
                } else {
                    serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197609_b, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 5, 0.25, 0.0, 0.25, 0.0);
                    worldIn.func_184133_a(null, pos, SoundEvents.field_194227_ie, SoundCategory.BLOCKS, 0.25f, 1.0f);
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("message.compactstorage.upgrade." + status.name().toLowerCase()), UUID.randomUUID());
                }
                return ActionResultType.SUCCESS;
            }
        } else if (player.func_184586_b(handIn).func_77973_b() instanceof DyeItem) {
            ServerWorld serverWorld = (ServerWorld)worldIn;
            DyeItem item = (DyeItem)player.func_184586_b(handIn).func_77973_b();
            Direction dir = (Direction)state.func_177229_b(PROPERTY_FACING);
            boolean waterlogged = (Boolean)state.func_177229_b((Property)WATERLOGGED);
            Block newBlock = CompactStorage.chest_blocks[item.func_195962_g().func_196059_a()];
            if (newBlock != this) {
                BlockState newState = (BlockState)((BlockState)CompactStorage.chest_blocks[item.func_195962_g().func_196059_a()].func_176223_P().func_206870_a(PROPERTY_FACING, (Comparable)dir)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
                worldIn.func_180501_a(pos, newState, 2);
                serverWorld.func_184133_a(null, pos, SoundEvents.field_187884_fr, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!player.func_184812_l_()) {
                    player.func_184586_b(handIn).func_190920_e(player.func_184586_b(handIn).func_190916_E() - 1);
                }
            }
        } else {
            INamedContainerProvider namedContainerProvider = this.func_220052_b(state, worldIn, pos);
            if (namedContainerProvider != null) {
                ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
                NetworkHooks.openGui((ServerPlayerEntity)serverPlayerEntity, (INamedContainerProvider)namedContainerProvider, packetBuffer -> packetBuffer.func_179255_a(pos));
            }
        }
        return ActionResultType.SUCCESS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(PROPERTY_FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{PROPERTY_FACING});
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.func_196283_a_(world);
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new CompactChestTileEntity();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(newState.func_177230_c() instanceof CompactChestBlock)) {
            TileEntity tile;
            if (!state.func_203425_a(newState.func_177230_c()) && (tile = worldIn.func_175625_s(pos)) instanceof CompactChestTileEntity) {
                CompactChestTileEntity chestTile = (CompactChestTileEntity)tile;
                ItemStack chestItem = new ItemStack((IItemProvider)state.func_177230_c(), 1);
                if (chestTile.width != 9 || chestTile.width != 3) {
                    CompoundNBT tag = chestItem.func_190925_c("BlockEntityTag");
                    tag.func_74768_a("width", chestTile.width);
                    tag.func_74768_a("height", chestTile.height);
                }
                NonNullList drops = NonNullList.func_191196_a();
                IItemHandler itemHandler = (IItemHandler)chestTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(NullPointerException::new);
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    drops.add((Object)itemHandler.getStackInSlot(i));
                }
                drops.add((Object)chestItem);
                InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, (NonNullList)drops);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int width = 9;
        int height = 3;
        boolean upgraded = false;
        boolean retaining = false;
        if (stack.func_77942_o() && stack.func_179543_a("BlockEntityTag") != null) {
            upgraded = true;
            CompoundNBT tag = stack.func_179543_a("BlockEntityTag");
            width = tag.func_74764_b("width") ? tag.func_74762_e("width") : 9;
            height = tag.func_74764_b("height") ? tag.func_74762_e("height") : 3;
            upgraded = width != 9 && height != 3;
            retaining = tag.func_74764_b("Inventory");
        }
        StringTextComponent widthComponent = new StringTextComponent("Width: ");
        widthComponent.func_230529_a_((ITextComponent)new StringTextComponent(width + "").func_240699_a_(TextFormatting.LIGHT_PURPLE));
        StringTextComponent heightComponent = new StringTextComponent("Height: ");
        heightComponent.func_230529_a_((ITextComponent)new StringTextComponent(height + "").func_240699_a_(TextFormatting.LIGHT_PURPLE));
        tooltip.add((ITextComponent)widthComponent);
        tooltip.add((ITextComponent)heightComponent);
        if (retaining) {
            tooltip.add((ITextComponent)new StringTextComponent("Retaining").func_240699_a_(TextFormatting.AQUA));
        }
        if (upgraded) {
            tooltip.add((ITextComponent)new StringTextComponent("Upgraded").func_240699_a_(TextFormatting.RED));
        }
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }
}

