/*
 * Decompiled with CFR 0.152.
 */
package me.tobystrong.compactstorage.block;

import java.util.List;
import java.util.UUID;
import me.tobystrong.compactstorage.CompactStorage;
import me.tobystrong.compactstorage.block.tile.CompactBarrelTileEntity;
import me.tobystrong.compactstorage.util.CompactStorageUtilMethods;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CompactBarrelBlock
extends ContainerBlock {
    public static EnumProperty<Direction> PROPERTY_FACING = EnumProperty.func_177709_a((String)"facing", Direction.class);
    public static BooleanProperty PROPERTY_OPEN = BooleanProperty.func_177716_a((String)"open");

    public CompactBarrelBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_200943_b(2.0f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(PROPERTY_FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)PROPERTY_OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack heldItem = player.func_184586_b(handIn);
        if (heldItem.func_77973_b() == CompactStorage.upgrade_column || heldItem.func_77973_b() == CompactStorage.upgrade_row) {
            TileEntity entity = worldIn.func_175625_s(pos);
            if (entity != null && worldIn instanceof ServerWorld) {
                ServerWorld serverWorld = (ServerWorld)worldIn;
                CompactBarrelTileEntity barrelTile = (CompactBarrelTileEntity)entity;
                CompactStorageUtilMethods.UpgradeStatus status = barrelTile.handleUpgradeItem(heldItem);
                if (status == CompactStorageUtilMethods.UpgradeStatus.SUCCESS) {
                    serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197632_y, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 5, 0.25, 0.0, 0.25, 0.0);
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187802_ec, SoundCategory.BLOCKS, 0.25f, 1.0f);
                    worldIn.func_184138_a(pos, state, state, 2);
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(handIn).func_190920_e(heldItem.func_190916_E() - 1);
                    }
                } else {
                    serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197609_b, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 5, 0.25, 0.0, 0.25, 0.0);
                    worldIn.func_184133_a(null, pos, SoundEvents.field_194227_ie, SoundCategory.BLOCKS, 0.25f, 1.0f);
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("message.compactstorage.upgrade." + status.name().toLowerCase()), UUID.randomUUID());
                }
                return ActionResultType.SUCCESS;
            }
        } else if (player.func_184586_b(handIn).func_77973_b() instanceof DyeItem) {
            ServerWorld serverWorld = (ServerWorld)worldIn;
            DyeItem item = (DyeItem)player.func_184586_b(handIn).func_77973_b();
            Direction dir = (Direction)state.func_177229_b(PROPERTY_FACING);
            Block newBlock = CompactStorage.barrel_blocks[item.func_195962_g().func_196059_a()];
            if (newBlock != this) {
                BlockState newState = (BlockState)CompactStorage.barrel_blocks[item.func_195962_g().func_196059_a()].func_176223_P().func_206870_a(PROPERTY_FACING, (Comparable)dir);
                worldIn.func_180501_a(pos, newState, 2);
                serverWorld.func_184133_a(null, pos, SoundEvents.field_187884_fr, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!player.func_184812_l_()) {
                    player.func_184586_b(handIn).func_190920_e(player.func_184586_b(handIn).func_190916_E() - 1);
                }
            }
        } else {
            INamedContainerProvider namedContainerProvider = this.func_220052_b(state, worldIn, pos);
            if (namedContainerProvider != null) {
                ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
                NetworkHooks.openGui((ServerPlayerEntity)serverPlayerEntity, (INamedContainerProvider)namedContainerProvider, packetBuffer -> packetBuffer.func_179255_a(pos));
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(newState.func_177230_c() instanceof CompactBarrelBlock)) {
            TileEntity tile;
            if (!state.func_203425_a(newState.func_177230_c()) && (tile = worldIn.func_175625_s(pos)) instanceof CompactBarrelTileEntity) {
                CompactBarrelTileEntity barrelTile = (CompactBarrelTileEntity)tile;
                ItemStack barrelItem = new ItemStack((IItemProvider)state.func_177230_c(), 1);
                if (barrelTile.width != 9 || barrelTile.width != 3) {
                    CompoundNBT tag = barrelItem.func_190925_c("BlockEntityTag");
                    tag.func_74768_a("width", barrelTile.width);
                    tag.func_74768_a("height", barrelTile.height);
                }
                NonNullList drops = NonNullList.func_191196_a();
                IItemHandler itemHandler = (IItemHandler)barrelTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(NullPointerException::new);
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    drops.add((Object)itemHandler.getStackInSlot(i));
                }
                drops.add((Object)barrelItem);
                InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, (NonNullList)drops);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompactStorageUtilMethods.addInformationForUpgradableBlocks(stack, worldIn, tooltip, flagIn);
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{PROPERTY_FACING, PROPERTY_OPEN});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a(PROPERTY_FACING, (Comparable)context.func_196010_d().func_176734_d());
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new CompactBarrelTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }
}

