/*
 * Decompiled with CFR 0.152.
 */
package me.tobystrong.compactstorage;

import me.tobystrong.compactstorage.block.CompactBarrelBlock;
import me.tobystrong.compactstorage.block.CompactChestBlock;
import me.tobystrong.compactstorage.block.tile.CompactBarrelTileEntity;
import me.tobystrong.compactstorage.block.tile.CompactChestTileEntity;
import me.tobystrong.compactstorage.client.gui.CompactChestContainerScreen;
import me.tobystrong.compactstorage.client.renderer.CompactChestTileEntityRenderer;
import me.tobystrong.compactstorage.container.BackpackContainer;
import me.tobystrong.compactstorage.container.CompactBarrelContainer;
import me.tobystrong.compactstorage.container.CompactChestContainer;
import me.tobystrong.compactstorage.item.BackpackItem;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="compactstorage")
public class CompactStorage {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ItemGroup compactStorageItemGroup = new ItemGroup("compact_storage"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)chest_blocks[0], 1);
        }
    };
    public static Block[] chest_blocks = new Block[DyeColor.values().length];
    public static Block[] barrel_blocks = new Block[DyeColor.values().length];
    public static TileEntityType<CompactChestTileEntity> COMPACT_CHEST_TILE_TYPE;
    public static TileEntityType<CompactBarrelTileEntity> COMPACT_BARREL_TILE_TYPE;
    public static ContainerType<CompactChestContainer> COMPACT_CHEST_CONTAINER_TYPE;
    public static ContainerType<BackpackContainer> BACKPACK_CONTAINER_TYPE;
    public static ContainerType<CompactBarrelContainer> BARREL_CONTAINER_TYPE;
    public static Item[] backpack_items;
    public static Item upgrade_row;
    public static Item upgrade_column;

    public CompactStorage() {
        int i;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        for (i = 0; i < DyeColor.values().length; ++i) {
            CompactStorage.chest_blocks[i] = (Block)new CompactChestBlock().setRegistryName(new ResourceLocation("compactstorage", "compact_chest_" + DyeColor.values()[i].name().toLowerCase()));
        }
        for (i = 0; i < DyeColor.values().length; ++i) {
            CompactStorage.barrel_blocks[i] = (Block)new CompactBarrelBlock().setRegistryName(new ResourceLocation("compactstorage", "compact_barrel_" + DyeColor.values()[i].name().toLowerCase()));
        }
        for (i = 0; i < DyeColor.values().length; ++i) {
            CompactStorage.backpack_items[i] = (Item)new BackpackItem().setRegistryName(new ResourceLocation("compactstorage", "backpack_" + DyeColor.values()[i].name().toLowerCase()));
        }
        upgrade_column = (Item)new Item(new Item.Properties().func_200917_a(64).func_200916_a(compactStorageItemGroup)).setRegistryName("compactstorage", "upgrade_column");
        upgrade_row = (Item)new Item(new Item.Properties().func_200917_a(64).func_200916_a(compactStorageItemGroup)).setRegistryName("compactstorage", "upgrade_row");
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ClientRegistry.bindTileEntityRenderer(COMPACT_CHEST_TILE_TYPE, CompactChestTileEntityRenderer::new);
        ScreenManager.func_216911_a(COMPACT_CHEST_CONTAINER_TYPE, CompactChestContainerScreen::new);
        ScreenManager.func_216911_a(BACKPACK_CONTAINER_TYPE, CompactChestContainerScreen::new);
        ScreenManager.func_216911_a(BARREL_CONTAINER_TYPE, CompactChestContainerScreen::new);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    static {
        backpack_items = new Item[DyeColor.values().length];
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            int i;
            for (i = 0; i < DyeColor.values().length; ++i) {
                blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)chest_blocks[i]);
            }
            for (i = 0; i < DyeColor.values().length; ++i) {
                blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)barrel_blocks[i]);
            }
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
            for (int i = 0; i < DyeColor.values().length; ++i) {
                itemRegistryEvent.getRegistry().register(new BlockItem(chest_blocks[i], new Item.Properties().func_200916_a(compactStorageItemGroup)).setRegistryName(chest_blocks[i].getRegistryName()));
                itemRegistryEvent.getRegistry().register(new BlockItem(barrel_blocks[i], new Item.Properties().func_200916_a(compactStorageItemGroup)).setRegistryName(barrel_blocks[i].getRegistryName()));
            }
            itemRegistryEvent.getRegistry().registerAll((IForgeRegistryEntry[])backpack_items);
            itemRegistryEvent.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{upgrade_column, upgrade_row});
        }

        @SubscribeEvent
        public static void onTileEntityTypeRegistry(RegistryEvent.Register<TileEntityType<?>> tileTypeRegistryEvent) {
            COMPACT_CHEST_TILE_TYPE = TileEntityType.Builder.func_223042_a(CompactChestTileEntity::new, (Block[])chest_blocks).func_206865_a(null);
            COMPACT_CHEST_TILE_TYPE.setRegistryName("compactstorage", "compact_chest");
            tileTypeRegistryEvent.getRegistry().register(COMPACT_CHEST_TILE_TYPE);
            COMPACT_BARREL_TILE_TYPE = TileEntityType.Builder.func_223042_a(CompactBarrelTileEntity::new, (Block[])barrel_blocks).func_206865_a(null);
            COMPACT_BARREL_TILE_TYPE.setRegistryName("compactstorage", "compact_barrel");
            tileTypeRegistryEvent.getRegistry().register(COMPACT_BARREL_TILE_TYPE);
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> containerTypeRegister) {
            COMPACT_CHEST_CONTAINER_TYPE = IForgeContainerType.create(CompactChestContainer::createContainerClientSide);
            COMPACT_CHEST_CONTAINER_TYPE.setRegistryName("compactstorage", "compact_chest");
            BACKPACK_CONTAINER_TYPE = IForgeContainerType.create(BackpackContainer::createContainerFromItemstack);
            BACKPACK_CONTAINER_TYPE.setRegistryName("compactstorage", "backpack");
            BARREL_CONTAINER_TYPE = IForgeContainerType.create(CompactBarrelContainer::createContainerClientSide);
            BARREL_CONTAINER_TYPE.setRegistryName("compactstorage", "compact_barrel");
            containerTypeRegister.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{COMPACT_CHEST_CONTAINER_TYPE, BACKPACK_CONTAINER_TYPE, BARREL_CONTAINER_TYPE});
        }
    }
}

