/*
 * Decompiled with CFR 0.152.
 */
package com.mcwdoors.kikoz.objects;

import com.mcwdoors.kikoz.init.SoundsInit;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class GarageDoor
extends Block
implements IWaterLoggable {
    public static final EnumProperty<GaragePart> PART = EnumProperty.func_177709_a((String)"part", GaragePart.class);
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    private static final VoxelShape EAST = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case WEST: {
                return NORTH;
            }
            case EAST: {
                return NORTH;
            }
            case NORTH: {
                return EAST;
            }
            case SOUTH: {
                return EAST;
            }
        }
        return null;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
            return VoxelShapes.func_197880_a();
        }
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case WEST: {
                return NORTH;
            }
            case EAST: {
                return NORTH;
            }
            case NORTH: {
                return EAST;
            }
            case SOUTH: {
                return EAST;
            }
        }
        return null;
    }

    public GarageDoor() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_235861_h_().func_200948_a(3.0f, 5.0f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a(PART, (Comparable)((Object)GaragePart.BOTTOM)));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            FluidState topFluidState = world.func_204610_c(pos.func_177981_b(1));
            Block block = world.func_180495_p(pos).func_177230_c();
            Block upper = world.func_180495_p(pos.func_177981_b(1)).func_177230_c();
            Block lower = world.func_180495_p(pos.func_177979_c(1)).func_177230_c();
            if (block == this && upper != block) {
                world.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.TOP))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)));
            } else {
                world.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.BOTTOM))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)));
            }
            if (block == this && upper != block && lower != block) {
                world.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.TOP))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)));
            }
            if (block == this && lower == block && upper != block) {
                world.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.TOP))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)));
                world.func_175656_a(pos.func_177979_c(1), (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.BOTTOM))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)));
            }
            if (block == this && lower == block && upper == block) {
                world.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.BOTTOM))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)));
                world.func_175656_a(pos.func_177979_c(1), (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.BOTTOM))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)));
            }
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos postwo, boolean bool) {
        boolean flag;
        boolean bl = world.func_175640_z(pos) || world.func_175640_z(pos.func_177972_a(state.func_177229_b(PART) == GaragePart.BOTTOM ? Direction.UP : Direction.DOWN)) || world.func_175640_z(pos.func_177972_a(state.func_177229_b(PART) == GaragePart.TOP ? Direction.UP : Direction.DOWN)) ? true : (flag = false);
        if (!this.func_176223_P().func_203425_a(block) && flag != (Boolean)state.func_177229_b((Property)POWERED)) {
            if (flag != (Boolean)state.func_177229_b((Property)OPEN)) {
                world.func_184133_a(null, pos, (SoundEvent)SoundsInit.GARAGE.get(), SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.8f);
                this.garageDoor(world, pos, (Boolean)state.func_177229_b((Property)OPEN) == false, (Direction)state.func_177229_b((Property)FACING), 1000);
            }
            world.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PART, FACING, POWERED, WATERLOGGED, OPEN});
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.func_177229_b((Property)OPEN);
    }

    public void openDoor(World worldIn, BlockState state, BlockPos pos, boolean open) {
        if (state.func_203425_a((Block)this) && (Boolean)state.func_177229_b((Property)OPEN) != open) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(open)));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        if (item == this.func_199767_j()) {
            return ActionResultType.PASS;
        }
        this.garageDoor(worldIn, pos, (Boolean)state.func_177229_b((Property)OPEN) == false, (Direction)state.func_177229_b((Property)FACING), 1000);
        worldIn.func_184133_a(null, pos, (SoundEvent)SoundsInit.GARAGE.get(), SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.8f);
        state = (BlockState)state.func_235896_a_((Property)OPEN);
        worldIn.func_180501_a(pos, state, 10);
        return ActionResultType.SUCCESS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        World level = context.func_195991_k();
        boolean flag = level.func_175640_z(blockpos) || level.func_175640_z(blockpos.func_177984_a());
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176746_e());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, World worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205359_a(currentPos, (Object)Fluids.field_204546_a);
        }
        return super.func_196271_a(stateIn, facing, facingState, (IWorld)worldIn, currentPos, facingPos);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207188_f() : super.func_204507_t(state);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        FluidState topFluidState = world.func_204610_c(pos.func_177981_b(1));
        Block block = world.func_180495_p(pos).func_177230_c();
        Block upper = world.func_180495_p(pos.func_177981_b(1)).func_177230_c();
        Block lower = world.func_180495_p(pos.func_177979_c(1)).func_177230_c();
        if (upper == block && lower == block) {
            world.func_175656_a(pos.func_177979_c(1), (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.TOP))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)));
        }
        if (lower == block) {
            world.func_175656_a(pos.func_177979_c(1), (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.TOP))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)));
        }
        world.func_184133_a(null, pos, SoundEvents.field_187766_dk, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.8f);
        world.func_217378_a(player, 2001, pos, GarageDoor.func_196246_j((BlockState)state));
    }

    private void garageDoor(World world, BlockPos pos, boolean targetOpen, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            boolean open = (Boolean)state.func_177229_b((Property)OPEN);
            Direction direction = (Direction)state.func_177229_b((Property)FACING);
            if (open != targetOpen && direction.equals((Object)targetDirection)) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(targetOpen)));
                switch (targetDirection) {
                    case NORTH: 
                    case SOUTH: {
                        this.garageDoor(world, pos.func_177970_e(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177964_d(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(1).func_177970_e(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(1).func_177964_d(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(2).func_177970_e(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(2).func_177964_d(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(2), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177981_b(1).func_177970_e(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177981_b(1).func_177964_d(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177981_b(1), targetOpen, targetDirection, depth - 2);
                    }
                    case WEST: 
                    case EAST: {
                        this.garageDoor(world, pos.func_177965_g(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177985_f(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(1).func_177965_g(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(1).func_177985_f(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(2).func_177965_g(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(2).func_177985_f(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(2), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177981_b(1).func_177965_g(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177981_b(1).func_177985_f(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177981_b(1), targetOpen, targetDirection, depth - 2);
                    }
                }
                return;
            }
        }
    }

    public static enum GaragePart implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private GaragePart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

