/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.util;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHelper {
    private static final Method MOD_CONFIG_SET_CONFIG_DATA = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"setConfigData", (Class[])new Class[]{CommentedConfig.class});
    private static final Method MOD_CONFIG_FIRE_EVENT = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"fireEvent", (Class[])new Class[]{ModConfig.ModConfigEvent.class});
    private static final Constructor<ModConfig.Reloading> MOD_CONFIG_RELOADING = ObfuscationReflectionHelper.findConstructor(ModConfig.Reloading.class, (Class[])new Class[]{ModConfig.class});

    public static boolean isModified(IModConfig config) {
        return ConfigHelper.gatherAllConfigValues(config).stream().anyMatch(T -> !T.isDefault());
    }

    public static List<IConfigValue<?>> gatherAllConfigValues(IModConfig config) {
        return ConfigHelper.gatherAllConfigValues(config.getRoot());
    }

    public static List<IConfigValue<?>> gatherAllConfigValues(IConfigEntry entry) {
        ObjectArrayList values = new ObjectArrayList();
        ConfigHelper.gatherValuesFromConfig(entry, values);
        return ImmutableList.copyOf((Collection)values);
    }

    private static void gatherValuesFromConfig(IConfigEntry entry, List<IConfigValue<?>> values) {
        if (entry.isLeaf()) {
            IConfigValue<?> value = entry.getValue();
            if (value != null) {
                values.add(value);
            }
            return;
        }
        for (IConfigEntry children : entry.getChildren()) {
            ConfigHelper.gatherValuesFromConfig(children, values);
        }
    }

    public static List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> gatherAllConfigValues(UnmodifiableConfig config, ForgeConfigSpec spec) {
        ArrayList values = new ArrayList();
        ConfigHelper.gatherValuesFromConfig(config, spec, values);
        return ImmutableList.copyOf(values);
    }

    private static void gatherValuesFromConfig(UnmodifiableConfig config, ForgeConfigSpec spec, List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> values) {
        config.valueMap().forEach((s, o) -> {
            if (o instanceof AbstractConfig) {
                ConfigHelper.gatherValuesFromConfig((UnmodifiableConfig)o, spec, values);
            } else if (o instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)o;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(configValue.getPath());
                values.add(Pair.of((Object)configValue, (Object)valueSpec));
            }
        });
    }

    public static void setConfigData(ModConfig config, @Nullable CommentedConfig configData) {
        try {
            MOD_CONFIG_SET_CONFIG_DATA.invoke((Object)config, configData);
            if (configData instanceof FileConfig) {
                config.save();
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static ModConfig getModConfig(String fileName) {
        ConcurrentHashMap configMap = (ConcurrentHashMap)ObfuscationReflectionHelper.getPrivateValue(ConfigTracker.class, (Object)ConfigTracker.INSTANCE, (String)"fileMap");
        return configMap != null ? (ModConfig)configMap.get(fileName) : null;
    }

    public static void fireEvent(ModConfig config, ModConfig.ModConfigEvent event) {
        try {
            MOD_CONFIG_FIRE_EVENT.invoke((Object)config, event);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static ModConfig.Reloading reloadingEvent(ModConfig config) {
        try {
            return MOD_CONFIG_RELOADING.newInstance(config);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void resetCache(IModConfig config) {
        ConfigHelper.gatherAllConfigValues(config).forEach(IConfigValue::cleanCache);
    }

    public static void resetCache(ModConfig config) {
        ConfigHelper.gatherAllConfigValues(config.getSpec().getValues(), config.getSpec()).forEach(pair -> ((ForgeConfigSpec.ConfigValue)pair.getLeft()).clearCache());
    }
}

