/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.impl.ForgeFolderEntry;
import com.mrcrayfish.configured.impl.ForgeListValue;
import com.mrcrayfish.configured.impl.ForgeValue;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraftforge.fml.config.ModConfig;

public class ForgeConfig
implements IModConfig {
    ModConfig config;

    public ForgeConfig(ModConfig config) {
        this.config = config;
    }

    @Override
    public void saveConfig(IConfigEntry entry) {
        CommentedConfig newConfig = CommentedConfig.copy((UnmodifiableCommentedConfig)this.config.getConfigData());
        ArrayDeque<IConfigEntry> found = new ArrayDeque<IConfigEntry>();
        found.add(entry);
        while (!found.isEmpty()) {
            ForgeListValue forgeList;
            Function<List<?>, List<?>> converter;
            IConfigEntry toSave = (IConfigEntry)found.poll();
            if (!toSave.isLeaf()) {
                found.addAll(toSave.getChildren());
                continue;
            }
            IConfigValue<?> value = toSave.getValue();
            if (value == null || !value.isChanged() || !(value instanceof ForgeValue)) continue;
            ForgeValue forge = (ForgeValue)value;
            if (forge instanceof ForgeListValue && (converter = (forgeList = (ForgeListValue)value).getConverter()) != null) {
                newConfig.set(forge.configValue.getPath(), converter.apply((List<?>)forgeList.get()));
                continue;
            }
            newConfig.set(forge.configValue.getPath(), value.get());
        }
        this.config.getConfigData().putAll((UnmodifiableConfig)newConfig);
        if (this.getConfigType() == ModConfig.Type.SERVER) {
            if (!ListMenuScreen.isPlayingGame()) {
                this.config.getHandler().unload(this.config.getFullPath().getParent(), this.config);
                ConfigHelper.setConfigData(this.config, null);
            }
        } else {
            Configured.LOGGER.info("Sending config reloading event for {}", (Object)this.config.getFileName());
            this.config.getSpec().afterReload();
            ConfigHelper.fireEvent(this.config, (ModConfig.ModConfigEvent)ConfigHelper.reloadingEvent(this.config));
        }
    }

    @Override
    public IConfigEntry getRoot() {
        return new ForgeFolderEntry("Root", this.config.getSpec().getValues(), this.config.getSpec(), true);
    }

    @Override
    public ModConfig.Type getConfigType() {
        return this.config.getType();
    }

    @Override
    public String getFileName() {
        return this.config.getFileName();
    }

    @Override
    public String getModId() {
        return this.config.getModId();
    }

    @Override
    public void loadServerConfig(Path path, Consumer<IModConfig> result) throws IOException {
        CommentedFileConfig data = (CommentedFileConfig)this.config.getHandler().reader(path).apply(this.config);
        ConfigHelper.setConfigData(this.config, (CommentedConfig)data);
        result.accept(this);
    }
}

