/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.angelring.utils;

import net.minecraft.entity.player.PlayerEntity;

public class ExperienceUtils {
    public static int getPlayerXP(PlayerEntity player) {
        return (int)((float)ExperienceUtils.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(PlayerEntity player, int amount) {
        int experience;
        player.field_71067_cb = experience = ExperienceUtils.getPlayerXP(player) + amount;
        player.field_71068_ca = ExperienceUtils.getLevelForExperience(experience);
        int expForLevel = ExperienceUtils.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return ExperienceUtils.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + ExperienceUtils.sum(level - 15, 37, 5);
        }
        return 1395 + ExperienceUtils.sum(level - 30, 112, 9);
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = ExperienceUtils.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    public static float calculateStoredLevels(int storedXP) {
        float storedLevels = 0.0f;
        int xp = storedXP;
        while (xp > 0) {
            int xpToNextLevel = ExperienceUtils.xpBarCap((int)storedLevels);
            if (xp < xpToNextLevel) {
                storedLevels += (float)xp / (float)xpToNextLevel;
                break;
            }
            xp -= xpToNextLevel;
            storedLevels += 1.0f;
        }
        return storedLevels;
    }

    public static int getXPToNextLevel(int currentXP) {
        int level = ExperienceUtils.getLevelForExperience(currentXP);
        int nextLevelXP = ExperienceUtils.getExperienceForLevel(level + 1);
        return nextLevelXP - currentXP;
    }

    public static void decreaseXP(PlayerEntity player, float amount) {
        if ((float)player.field_71067_cb - amount <= 0.0f) {
            player.field_71068_ca = 0;
            player.field_71106_cc = 0.0f;
            player.field_71067_cb = 0;
            return;
        }
        player.field_71067_cb = (int)((float)player.field_71067_cb - amount);
        if (player.field_71106_cc * (float)ExperienceUtils.xpBarCap(player.field_71068_ca) <= amount) {
            amount -= player.field_71106_cc * (float)ExperienceUtils.xpBarCap(player.field_71068_ca);
            player.field_71106_cc = 1.0f;
            --player.field_71068_ca;
        }
        while ((float)ExperienceUtils.xpBarCap(player.field_71068_ca) < amount) {
            amount -= (float)ExperienceUtils.xpBarCap(player.field_71068_ca);
            --player.field_71068_ca;
        }
        player.field_71106_cc -= amount / (float)ExperienceUtils.xpBarCap(player.field_71068_ca);
    }
}

