/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.angelring.item.utils;

import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyItem
implements IEnergyStorage {
    private final ItemStack stack;
    private final int capacity;

    public EnergyItem(ItemStack stack, int capacity) {
        this.stack = stack;
        this.capacity = capacity;
    }

    public int receiveEnergy(int maxReceived, boolean simulate) {
        int stored = this.getEnergyStored();
        int received = Math.max(0, Math.min(maxReceived, this.getMaxEnergyStored() - stored));
        if (!simulate) {
            this.stack.func_196082_o().func_74768_a("energy", stored + received);
        }
        return received;
    }

    public int extractEnergy(int maxExtracted, boolean simulate) {
        int stored = this.getEnergyStored();
        int extracted = Math.max(0, Math.min(maxExtracted, stored));
        if (!simulate) {
            this.stack.func_196082_o().func_74768_a("energy", stored - extracted);
        }
        return extracted;
    }

    public int getEnergyStored() {
        return this.stack.func_77942_o() && this.stack.func_77978_p().func_74764_b("energy") ? this.stack.func_77978_p().func_74762_e("energy") : 0;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.getEnergyStored() > 0;
    }

    public boolean canReceive() {
        return this.getEnergyStored() < this.getMaxEnergyStored();
    }
}

