/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.angelring.item.thermal;

import dev.denismasterherobrine.angelring.compat.curios.ClassicAngelRingIntegration;
import dev.denismasterherobrine.angelring.compat.thermal.HardenedAngelRingIntegration;
import dev.denismasterherobrine.angelring.utils.AngelRingTab;
import dev.denismasterherobrine.angelring.utils.ExternalMods;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;

public class HardenedAngelRing
extends Item {
    public HardenedAngelRing() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(AngelRingTab.ANGELRING2));
    }

    @SubscribeEvent
    public static void sendImc(InterModEnqueueEvent event) {
        if (ExternalMods.CURIOS.isLoaded()) {
            ClassicAngelRingIntegration.sendImc();
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT unused) {
        if (ExternalMods.CURIOS.isLoaded()) {
            return HardenedAngelRingIntegration.initCapabilities(stack);
        }
        return super.initCapabilities(stack, unused);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        return energy.getEnergyStored() < energy.getMaxEnergyStored();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY, null).map(e -> 1.0 - (double)e.getEnergyStored() / (double)e.getMaxEnergyStored()).orElse(0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag tooltipFlag) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (!Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.angelring.energetic_angel_ring.tooltip").func_240699_a_(TextFormatting.GRAY));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.angelring.energetic_angel_ring.desc0").func_240699_a_(TextFormatting.GOLD));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.angelring.energetic_angel_ring.desc1", new Object[]{energy.getEnergyStored(), energy.getMaxEnergyStored()}).func_240699_a_(TextFormatting.GRAY));
        }
    }
}

