/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.angelring.compat.thermal;

import dev.denismasterherobrine.angelring.compat.curios.AbstractRingCurio;
import dev.denismasterherobrine.angelring.config.Configuration;
import dev.denismasterherobrine.angelring.item.utils.EnergyItem;
import dev.denismasterherobrine.angelring.register.ItemRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class ReinforcedAngelRingIntegration {
    public static ICapabilityProvider initCapabilities(ItemStack stack) {
        final AbstractRingCurio curio = new AbstractRingCurio(ItemRegistry.ReinforcedAngelRing){
            private final int fePerTick = (Integer)Configuration.ReinforcedFEPerTick.get();

            private IEnergyStorage getEnergyStorage(ItemStack stack) {
                return (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY).resolve().get();
            }

            @Override
            protected boolean checkIfAllowedToFly(PlayerEntity player, ItemStack stack) {
                return this.getEnergyStorage(stack).getEnergyStored() > 1;
            }

            @Override
            protected TextComponent getNotAbleToFlyMessage() {
                return new TranslationTextComponent("item.angelring.energetic_angel_ring.not_enough_fe");
            }

            @Override
            protected void payForFlight(PlayerEntity player, ItemStack stack) {
                this.getEnergyStorage(stack).extractEnergy(this.fePerTick, false);
            }
        };
        final EnergyItem energyItem = new EnergyItem(stack, (Integer)Configuration.ReinforcedCapacity.get());
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);
            private final LazyOptional<IEnergyStorage> energyStorageOpt = LazyOptional.of(() -> energyItem);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == CapabilityEnergy.ENERGY) {
                    return this.energyStorageOpt.cast();
                }
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
    }

    public static boolean isRingInCuriosSlot(ItemStack angelRing, LivingEntity player) {
        return CuriosApi.getCuriosHelper().findEquippedCurio(angelRing.func_77973_b(), player).isPresent();
    }
}

