/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.angelring.compat.curios;

import dev.denismasterherobrine.angelring.register.ItemRegistry;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurio;

public abstract class AbstractRingCurio
implements ICurio {
    private final Item item;

    public AbstractRingCurio(Item item) {
        this.item = item;
    }

    public boolean canEquipFromUse(SlotContext slotContext) {
        return true;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack) {
        if (newStack.func_77973_b().getClass() == this.item.getClass()) {
            return;
        }
        if (newStack.getCapability(CapabilityEnergy.ENERGY).isPresent() && this.item.func_190903_i().getCapability(CapabilityEnergy.ENERGY).isPresent() && ((IEnergyStorage)newStack.getCapability(CapabilityEnergy.ENERGY).resolve().get()).getEnergyStored() == ((IEnergyStorage)this.item.func_190903_i().getCapability(CapabilityEnergy.ENERGY).resolve().get()).getEnergyStored()) {
            return;
        }
        LivingEntity livingEntity = slotContext.getWearer();
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)livingEntity;
            if (player.func_184812_l_() || player.func_175149_v()) {
                return;
            }
            this.stopFlying(player);
        }
    }

    private void startFlying(PlayerEntity player) {
        player.field_71075_bZ.field_75101_c = true;
        player.func_71016_p();
    }

    private void stopFlying(PlayerEntity player) {
        player.field_71075_bZ.field_75100_b = false;
        player.field_71075_bZ.field_75101_c = false;
        player.func_71016_p();
    }

    public boolean canEquip(String identifier, LivingEntity entityLivingBase) {
        return !CuriosApi.getCuriosHelper().findFirstCurio(entityLivingBase, ItemRegistry.ItemRing).isPresent();
    }

    public void onEquipFromUse(SlotContext slotContext) {
        slotContext.getWearer().func_184185_a(SoundEvents.field_191258_p, 1.0f, 1.0f);
    }

    public boolean showAttributesTooltip(String identifier) {
        return true;
    }

    protected abstract boolean checkIfAllowedToFly(PlayerEntity var1, ItemStack var2);

    protected abstract TextComponent getNotAbleToFlyMessage();

    protected abstract void payForFlight(PlayerEntity var1, ItemStack var2);

    public void curioTick(String identifier, int index, LivingEntity livingEntity) {
        Optional optStack = CuriosApi.getCuriosHelper().findFirstCurio(livingEntity, this.item);
        if (!optStack.isPresent()) {
            return;
        }
        ItemStack stack = ((SlotResult)optStack.get()).getStack();
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)livingEntity;
            if (player.func_184812_l_() || player.func_175149_v()) {
                return;
            }
            if (this.checkIfAllowedToFly(player, stack) && !player.field_71075_bZ.field_75101_c) {
                this.startFlying(player);
            } else if (!this.checkIfAllowedToFly(player, stack) && player.field_71075_bZ.field_75101_c) {
                this.stopFlying(player);
                if (player instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)player).func_241151_a_((ITextComponent)this.getNotAbleToFlyMessage(), ChatType.GAME_INFO, player.func_110124_au());
                }
            }
            if (player.field_71075_bZ.field_75101_c && player.field_71075_bZ.field_75100_b) {
                this.payForFlight(player, stack);
            }
        }
    }
}

