/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.varia;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import romelo333.notenoughwands.varia.IEnergyItem;

public class ItemCapabilityProvider
implements ICapabilityProvider {
    private final ItemStack itemStack;
    private final IEnergyItem item;
    private final LazyOptional<IEnergyStorage> energyStorage = LazyOptional.of(this::createEnergyStorage);

    public ItemCapabilityProvider(ItemStack itemStack, IEnergyItem item) {
        this.itemStack = itemStack;
        this.item = item;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return null;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.energyStorage.cast();
        }
        return LazyOptional.empty();
    }

    private IEnergyStorage createEnergyStorage() {
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return ItemCapabilityProvider.this.item.receiveEnergy(ItemCapabilityProvider.this.itemStack, maxReceive, simulate);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return ItemCapabilityProvider.this.item.extractEnergy(ItemCapabilityProvider.this.itemStack, maxExtract, simulate);
            }

            public int getEnergyStored() {
                return ItemCapabilityProvider.this.item.getEnergyStored(ItemCapabilityProvider.this.itemStack);
            }

            public int getMaxEnergyStored() {
                return ItemCapabilityProvider.this.item.getMaxEnergyStored(ItemCapabilityProvider.this.itemStack);
            }

            public boolean canExtract() {
                return true;
            }

            public boolean canReceive() {
                return true;
            }
        };
    }
}

