/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.protectionwand.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import romelo333.notenoughwands.modules.protectionwand.ProtectedBlocks;
import romelo333.notenoughwands.modules.protectionwand.network.PacketGetProtectedBlockCount;
import romelo333.notenoughwands.modules.protectionwand.network.PacketGetProtectedBlocks;
import romelo333.notenoughwands.modules.protectionwand.network.ReturnProtectedBlockCountHelper;
import romelo333.notenoughwands.modules.protectionwand.network.ReturnProtectedBlocksHelper;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.network.NEWPacketHandler;
import romelo333.notenoughwands.varia.Tools;

public class ProtectionWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_PROTECT = 0;
    public static final int MODE_UNPROTECT = 1;
    public static final int MODE_CLEAR = 2;
    public static final int MODE_LAST = 2;
    private final boolean master;
    public static final String[] descriptions = new String[]{"protect", "unprotect", "clear all"};
    private static long tooltipLastTime = 0L;
    private static long lastTime = 0L;

    public ProtectionWand(boolean master) {
        if (master) {
            this.usageFactor(3.0f);
        } else {
            this.usageFactor(3.0f);
        }
        this.master = master;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flagIn) {
        super.func_77624_a(stack, world, list, flagIn);
        boolean hasid = stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("id");
        int mode = this.getMode(stack);
        int id = this.getId(stack);
        if (hasid && id != 0 && System.currentTimeMillis() - tooltipLastTime > 250L) {
            tooltipLastTime = System.currentTimeMillis();
            NEWPacketHandler.INSTANCE.sendToServer((Object)new PacketGetProtectedBlockCount(id));
        }
        list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Mode: " + descriptions[mode]));
        if (this.master) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Master wand"));
        } else if (id != 0) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Id: " + id));
        }
        if (hasid) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Number of protected blocks: " + ReturnProtectedBlockCountHelper.count));
        }
        list.add((ITextComponent)new StringTextComponent("Right click to protect or unprotect a block."));
        this.showModeKeyDescription(list, "switch mode");
    }

    @Override
    public void toggleMode(PlayerEntity player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 2) {
            mode = 0;
        }
        Tools.notify(player, (IFormattableTextComponent)new StringTextComponent("Switched to " + descriptions[mode] + " mode"));
        stack.func_196082_o().func_74768_a("mode", mode);
    }

    private int getMode(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("mode");
    }

    public int getId(ItemStack stack) {
        if (this.master) {
            return -1;
        }
        return stack.func_196082_o().func_74762_e("id");
    }

    @Override
    public void renderOverlay(RenderWorldLastEvent evt, PlayerEntity player, ItemStack wand) {
        if (System.currentTimeMillis() - lastTime > 250L) {
            lastTime = System.currentTimeMillis();
            NEWPacketHandler.INSTANCE.sendToServer((Object)new PacketGetProtectedBlocks());
        }
        if (this.master) {
            ProtectionWand.renderOutlines(evt, player, ReturnProtectedBlocksHelper.childBlocks, 30, 30, 200);
        }
        ProtectionWand.renderOutlines(evt, player, ReturnProtectedBlocksHelper.blocks, 210, 60, 40);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
            int id = this.getOrCreateId(stack, world, protectedBlocks);
            int mode = this.getMode(stack);
            if (mode == 0) {
                if (!this.checkUsage(stack, player, 1.0f)) {
                    return ActionResultType.FAIL;
                }
                if (!protectedBlocks.protect(player, world, pos, id)) {
                    return ActionResultType.FAIL;
                }
                this.registerUsage(stack, player, 1.0f);
            } else if (mode == 1) {
                if (!protectedBlocks.unprotect(player, world, pos, id)) {
                    return ActionResultType.FAIL;
                }
            } else {
                int cnt = protectedBlocks.clearProtections(world, id);
                Tools.notify(player, (IFormattableTextComponent)new StringTextComponent("Cleared " + cnt + " protected blocks"));
            }
        }
        return ActionResultType.SUCCESS;
    }

    private int getOrCreateId(ItemStack stack, World world, ProtectedBlocks protectedBlocks) {
        int id = this.getId(stack);
        if (id == 0) {
            id = protectedBlocks.getNewId();
            stack.func_196082_o().func_74768_a("id", id);
        }
        return id;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.master;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (this.hasContainerItem(stack) && stack.func_77942_o()) {
            ItemStack container = new ItemStack((IItemProvider)this.func_77668_q());
            container.func_77982_d(stack.func_77978_p().func_74737_b());
            return container;
        }
        return ItemStack.field_190927_a;
    }
}

