/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.protectionwand;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import romelo333.notenoughwands.modules.protectionwand.ProtectionWandConfiguration;
import romelo333.notenoughwands.varia.Tools;

public class ProtectedBlocks
extends AbstractWorldData<ProtectedBlocks> {
    private static final String NAME = "NEWProtectedBlocks";
    private Map<GlobalPos, Integer> blocks = new HashMap<GlobalPos, Integer>();
    private Map<Pair<RegistryKey<World>, ChunkPos>, Set<BlockPos>> perDimPerChunkCache = new HashMap<Pair<RegistryKey<World>, ChunkPos>, Set<BlockPos>>();
    private Map<Integer, Integer> counter = new HashMap<Integer, Integer>();
    private int lastId = 1;
    public static RegistryKey<World> clientSideWorld = null;
    public static Map<ChunkPos, Set<BlockPos>> clientSideProtectedBlocks = new HashMap<ChunkPos, Set<BlockPos>>();

    public ProtectedBlocks(String name) {
        super(name);
    }

    public static ProtectedBlocks getProtectedBlocks(World world) {
        return (ProtectedBlocks)ProtectedBlocks.getData((World)world, () -> new ProtectedBlocks(NAME), (String)NAME);
    }

    public static boolean isProtectedClientSide(World world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        if (!clientSideProtectedBlocks.containsKey(chunkPos)) {
            return false;
        }
        Set<BlockPos> positions = clientSideProtectedBlocks.get(chunkPos);
        return positions.contains(pos);
    }

    public int getNewId() {
        ++this.lastId;
        this.save();
        return this.lastId - 1;
    }

    private void decrementProtection(Integer oldId) {
        int cnt = this.counter.containsKey(oldId) ? this.counter.get(oldId) : 0;
        this.counter.put(oldId, --cnt);
    }

    private void incrementProtection(Integer newId) {
        int cnt = this.counter.containsKey(newId) ? this.counter.get(newId) : 0;
        this.counter.put(newId, ++cnt);
    }

    public int getProtectedBlockCount(int id) {
        return this.counter.containsKey(id) ? this.counter.get(id) : 0;
    }

    private int getMaxProtectedBlocks(int id) {
        if (id == -1) {
            return 0;
        }
        return (Integer)ProtectionWandConfiguration.maximumProtectedBlocks.get();
    }

    public boolean protect(PlayerEntity player, World world, BlockPos pos, int id) {
        int max;
        GlobalPos key = GlobalPos.func_239648_a_((RegistryKey)world.func_234923_W_(), (BlockPos)pos);
        if (id != -1 && this.blocks.containsKey(key)) {
            Tools.error(player, "This block is already protected!");
            return false;
        }
        if (this.blocks.containsKey(key)) {
            this.decrementProtection(this.blocks.get(key));
        }
        if ((max = this.getMaxProtectedBlocks(id)) != 0 && this.getProtectedBlockCount(id) >= max) {
            Tools.error(player, "Maximum number of protected blocks reached!");
            return false;
        }
        this.blocks.put(key, id);
        this.clearCache(key);
        this.incrementProtection(id);
        this.save();
        return true;
    }

    public boolean unprotect(PlayerEntity player, World world, BlockPos pos, int id) {
        GlobalPos key = GlobalPos.func_239648_a_((RegistryKey)world.func_234923_W_(), (BlockPos)pos);
        if (!this.blocks.containsKey(key)) {
            Tools.error(player, "This block is not protected!");
            return false;
        }
        if (id != -1 && this.blocks.get(key) != id) {
            Tools.error(player, "You have no permission to unprotect this block!");
            return false;
        }
        this.decrementProtection(this.blocks.get(key));
        this.blocks.remove(key);
        this.clearCache(key);
        this.save();
        return true;
    }

    public int clearProtections(World world, int id) {
        HashSet<GlobalPos> toRemove = new HashSet<GlobalPos>();
        for (Map.Entry<GlobalPos, Integer> entry : this.blocks.entrySet()) {
            if (entry.getValue() != id) continue;
            toRemove.add(entry.getKey());
        }
        int cnt = 0;
        for (GlobalPos coordinate : toRemove) {
            ++cnt;
            this.blocks.remove(coordinate);
            this.clearCache(coordinate);
        }
        this.counter.put(id, 0);
        this.save();
        return cnt;
    }

    public boolean isProtected(World world, BlockPos pos) {
        return this.blocks.containsKey(GlobalPos.func_239648_a_((RegistryKey)world.func_234923_W_(), (BlockPos)pos));
    }

    public boolean hasProtections() {
        return !this.blocks.isEmpty();
    }

    public void fetchProtectedBlocks(Set<BlockPos> coordinates, World world, int x, int y, int z, float radius, int id) {
        radius *= radius;
        for (Map.Entry<GlobalPos, Integer> entry : this.blocks.entrySet()) {
            BlockPos c;
            float sqdist;
            GlobalPos block;
            if (entry.getValue() != id && (id != -2 || entry.getValue() == -1) || !(block = entry.getKey()).func_239646_a_().equals(world.func_234923_W_()) || !((sqdist = (float)((x - (c = block.func_218180_b()).func_177958_n()) * (x - c.func_177958_n()) + (y - c.func_177956_o()) * (y - c.func_177956_o()) + (z - c.func_177952_p()) * (z - c.func_177952_p()))) < radius)) continue;
            coordinates.add(c);
        }
    }

    private void clearCache(GlobalPos pos) {
        ChunkPos chunkpos = new ChunkPos(pos.func_218180_b());
        this.perDimPerChunkCache.remove(Pair.of((Object)pos.func_239646_a_(), (Object)chunkpos));
    }

    public Map<ChunkPos, Set<BlockPos>> fetchProtectedBlocks(World world, BlockPos pos) {
        HashMap<ChunkPos, Set<BlockPos>> result = new HashMap<ChunkPos, Set<BlockPos>>();
        ChunkPos chunkpos = new ChunkPos(pos);
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a - 1, chunkpos.field_77275_b - 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a, chunkpos.field_77275_b - 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a + 1, chunkpos.field_77275_b - 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a - 1, chunkpos.field_77275_b));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a, chunkpos.field_77275_b));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a + 1, chunkpos.field_77275_b));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a - 1, chunkpos.field_77275_b + 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a, chunkpos.field_77275_b + 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a + 1, chunkpos.field_77275_b + 1));
        return result;
    }

    public void fetchProtectedBlocks(Map<ChunkPos, Set<BlockPos>> allresults, World world, ChunkPos chunkpos) {
        Pair key = Pair.of((Object)world.func_234923_W_(), (Object)chunkpos);
        if (this.perDimPerChunkCache.containsKey(key)) {
            allresults.put(chunkpos, this.perDimPerChunkCache.get(key));
            return;
        }
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        for (Map.Entry<GlobalPos, Integer> entry : this.blocks.entrySet()) {
            ChunkPos bc;
            GlobalPos block = entry.getKey();
            if (!block.func_239646_a_().equals(world.func_234923_W_()) || !(bc = new ChunkPos(block.func_218180_b())).equals((Object)chunkpos)) continue;
            result.add(block.func_218180_b());
        }
        allresults.put(chunkpos, result);
        this.perDimPerChunkCache.put((Pair<RegistryKey<World>, ChunkPos>)key, result);
    }

    public void func_76184_a(CompoundNBT tagCompound) {
        this.lastId = tagCompound.func_74762_e("lastId");
        this.blocks.clear();
        this.perDimPerChunkCache.clear();
        this.counter.clear();
        ListNBT list = tagCompound.func_150295_c("blocks", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tc = list.func_150305_b(i);
            String dim = tc.func_74779_i("dim");
            GlobalPos block = GlobalPos.func_239648_a_((RegistryKey)LevelTools.getId((ResourceLocation)new ResourceLocation(dim)), (BlockPos)new BlockPos(tc.func_74762_e("x"), tc.func_74762_e("y"), tc.func_74762_e("z")));
            int id = tc.func_74762_e("id");
            this.blocks.put(block, id);
            this.incrementProtection(id);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT tagCompound) {
        tagCompound.func_74768_a("lastId", this.lastId);
        ListNBT list = new ListNBT();
        for (Map.Entry<GlobalPos, Integer> entry : this.blocks.entrySet()) {
            GlobalPos block = entry.getKey();
            CompoundNBT tc = new CompoundNBT();
            tc.func_74768_a("x", block.func_218180_b().func_177958_n());
            tc.func_74768_a("y", block.func_218180_b().func_177956_o());
            tc.func_74768_a("z", block.func_218180_b().func_177952_p());
            tc.func_74778_a("dim", block.func_239646_a_().func_240901_a_().toString());
            tc.func_74768_a("id", entry.getValue().intValue());
            list.add((Object)tc);
        }
        tagCompound.func_218657_a("blocks", (INBT)list);
        return tagCompound;
    }
}

