/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.buildingwands.items;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.SoundTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import romelo333.notenoughwands.modules.buildingwands.BuildingWandsConfiguration;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class DisplacementWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_3X3 = 0;
    public static final int MODE_5X5 = 1;
    public static final int MODE_7X7 = 2;
    public static final int MODE_SINGLE = 3;
    public static final int MODE_LAST = 3;
    public static final String[] DESCRIPTIONS = new String[]{"3x3", "5x5", "7x7", "single"};
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"mode", stack -> DESCRIPTIONS[this.getMode((ItemStack)stack)])});

    public DisplacementWand() {
        this.usageFactor(1.0f);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, list, flagIn);
        this.tooltipBuilder.makeTooltip(this.getRegistryName(), stack, list, flagIn);
        this.showModeKeyDescription(list, "switch mode");
    }

    @Override
    public void toggleMode(PlayerEntity player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 3) {
            mode = 0;
        }
        Tools.notify(player, (IFormattableTextComponent)new StringTextComponent("Switched to " + DESCRIPTIONS[mode] + " mode"));
        stack.func_196082_o().func_74768_a("mode", mode);
    }

    private int getMode(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("mode");
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        if (!world.field_72995_K) {
            if (player.func_225608_bj_()) {
                this.pullBlocks(stack, player, world, pos, side);
            } else {
                this.pushBlocks(stack, player, world, pos, side);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private void pullBlocks(ItemStack stack, PlayerEntity player, World world, BlockPos pos, Direction side) {
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        Set<BlockPos> coordinates = this.findSuitableBlocks(stack, world, side, pos);
        int cnt = this.moveBlocks(player, world, coordinates, side);
        if (cnt > 0) {
            this.registerUsage(stack, player, 1.0f);
        }
    }

    private void pushBlocks(ItemStack stack, PlayerEntity player, World world, BlockPos pos, Direction side) {
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        Set<BlockPos> coordinates = this.findSuitableBlocks(stack, world, side, pos);
        int cnt = this.moveBlocks(player, world, coordinates, side.func_176734_d());
        if (cnt > 0) {
            this.registerUsage(stack, player, 1.0f);
        }
    }

    private int moveBlocks(PlayerEntity player, World world, Set<BlockPos> coordinates, Direction direction) {
        int cnt = 0;
        for (BlockPos coordinate : coordinates) {
            double cost;
            BlockState state = world.func_180495_p(coordinate);
            Block block = state.func_177230_c();
            BlockPos otherC = coordinate.func_177972_a(direction);
            BlockState otherState = world.func_180495_p(otherC);
            if (!otherState.func_185904_a().func_76222_j() || !((cost = GenericWand.checkPickup(player, world, otherC, state, (Double)BuildingWandsConfiguration.maxHardness.get())) >= 0.0)) continue;
            ++cnt;
            SoundTools.playSound((World)world, (SoundEvent)block.func_220072_p(state).func_185844_d(), (double)coordinate.func_177958_n(), (double)coordinate.func_177956_o(), (double)coordinate.func_177952_p(), (double)1.0, (double)1.0);
            TileEntity tileEntity = world.func_175625_s(coordinate);
            CompoundNBT tc = null;
            if (tileEntity != null) {
                tc = new CompoundNBT();
                tileEntity.func_189515_b(tc);
                world.func_175713_t(coordinate);
            }
            world.func_175656_a(coordinate, Blocks.field_150350_a.func_176223_P());
            BlockSnapshot blocksnapshot = BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)otherC);
            BlockState blockState = block.func_176223_P();
            world.func_180501_a(otherC, blockState, 3);
            if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
                blocksnapshot.restore(true, false);
                world.func_180501_a(coordinate, blockState, 3);
                otherC = coordinate;
            }
            if (tc == null) continue;
            tc.func_74768_a("x", otherC.func_177958_n());
            tc.func_74768_a("y", otherC.func_177956_o());
            tc.func_74768_a("z", otherC.func_177952_p());
            tileEntity = TileEntity.func_235657_b_((BlockState)blockState, (CompoundNBT)tc);
            if (tileEntity == null) continue;
            world.func_217349_x(otherC).func_177426_a(otherC, tileEntity);
            tileEntity.func_70296_d();
            world.func_184138_a(otherC, blockState, blockState, 3);
        }
        return cnt;
    }

    @Override
    public void renderOverlay(RenderWorldLastEvent evt, PlayerEntity player, ItemStack wand) {
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver instanceof BlockRayTraceResult) {
            BlockPos blockPos;
            BlockRayTraceResult br = (BlockRayTraceResult)mouseOver;
            World world = player.func_130014_f_();
            BlockState state = world.func_180495_p(blockPos = br.func_216350_a());
            if (!state.isAir((IBlockReader)world, blockPos)) {
                Set<BlockPos> coordinates = this.findSuitableBlocks(wand, world, br.func_216354_b(), blockPos);
                DisplacementWand.renderOutlines(evt, player, coordinates, 200, 230, 180);
            }
        }
    }

    private Set<BlockPos> findSuitableBlocks(ItemStack stack, World world, Direction sideHit, BlockPos pos) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        int mode = this.getMode(stack);
        int dim = 0;
        switch (mode) {
            case 3: {
                coordinates.add(pos);
                return coordinates;
            }
            case 0: {
                dim = 1;
                break;
            }
            case 1: {
                dim = 2;
                break;
            }
            case 2: {
                dim = 3;
            }
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        switch (sideHit) {
            case UP: 
            case DOWN: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, dx, y, dz, coordinates);
                    }
                }
                break;
            }
            case SOUTH: 
            case NORTH: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dy = y - dim; dy <= y + dim; ++dy) {
                        this.checkAndAddBlock(world, dx, dy, z, coordinates);
                    }
                }
                break;
            }
            case EAST: 
            case WEST: {
                for (int dy = y - dim; dy <= y + dim; ++dy) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, x, dy, dz, coordinates);
                    }
                }
                break;
            }
        }
        return coordinates;
    }

    private void checkAndAddBlock(World world, int x, int y, int z, Set<BlockPos> coordinates) {
        BlockPos pos = new BlockPos(x, y, z);
        if (!world.func_175623_d(pos)) {
            coordinates.add(pos);
        }
    }
}

