/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands;

import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import romelo333.notenoughwands.modules.protectionwand.ProtectedBlocks;
import romelo333.notenoughwands.modules.protectionwand.ProtectionWandConfiguration;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        IWorld world = event.getWorld();
        if (world.func_201670_d()) {
            return;
        }
        BlockPos pos = event.getPos();
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks((World)world);
        if (protectedBlocks.isProtected((World)world, pos)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onDetonate(ExplosionEvent.Detonate event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (!protectedBlocks.hasProtections()) {
            return;
        }
        List affectedBlocks = event.getAffectedBlocks();
        int i = 0;
        while (i < affectedBlocks.size()) {
            BlockPos block = (BlockPos)affectedBlocks.get(i);
            if (protectedBlocks.isProtected(world, block)) {
                affectedBlocks.remove(i);
                continue;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        if (!event.isCancelable()) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (world.field_72995_K) {
            if (ProtectedBlocks.isProtectedClientSide(world, pos)) {
                event.setCanceled(true);
            }
        } else {
            ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
            if (protectedBlocks != null && protectedBlocks.isProtected(world, pos)) {
                if (((Boolean)ProtectionWandConfiguration.interactionProtection.get()).booleanValue()) {
                    event.setCanceled(true);
                } else if (event instanceof PlayerInteractEvent.LeftClickBlock) {
                    event.setCanceled(true);
                }
                return;
            }
        }
    }
}

