/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity.device;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.tileentity.ITilePacketHandler;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.device.DeviceTreeExtractorContainer;
import cofh.thermal.core.util.managers.device.TreeExtractorManager;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.DeviceTileBase;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DeviceTreeExtractorTile
extends DeviceTileBase
implements ITickableTileEntity {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "Fluid", "Filter");
    protected static final int NUM_LEAVES = 3;
    protected static int timeConstant = 500;
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && TreeExtractorManager.instance().validBoost((ItemStack)item));
    protected FluidStorageCoFH outputTank = new FluidStorageCoFH(8000);
    protected boolean cached;
    protected boolean valid;
    protected BlockPos trunkPos;
    protected final BlockPos[] leafPos = new BlockPos[3];
    protected int process = timeConstant / 2;
    protected int boostCycles;
    protected int boostMax = TreeExtractorManager.instance().getDefaultEnergy();
    protected float boostMult;

    public static void setTimeConstant(int configConstant) {
        timeConstant = configConstant;
    }

    public DeviceTreeExtractorTile() {
        super(TCoreReferences.DEVICE_TREE_EXTRACTOR_TILE);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.tankInv.addTank(this.outputTank, StorageGroup.OUTPUT);
        this.addAugmentSlots(ThermalConfig.deviceAugments);
        this.initHandlers();
        this.trunkPos = new BlockPos((Vector3i)this.field_174879_c);
        for (int i = 0; i < 3; ++i) {
            this.leafPos[i] = new BlockPos((Vector3i)this.field_174879_c);
        }
    }

    @Override
    protected void updateValidity() {
        int leafCount;
        Set<BlockState> leafSet;
        if (this.field_145850_b == null || !this.field_145850_b.isAreaLoaded(this.field_174879_c, 1) || Utils.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        if (this.valid) {
            if (this.isTrunkBase(this.trunkPos)) {
                leafSet = TreeExtractorManager.instance().getMatchingLeaves(this.field_145850_b.func_180495_p(this.trunkPos));
                leafCount = 0;
                for (int i = 0; i < 3; ++i) {
                    if (!leafSet.contains(this.field_145850_b.func_180495_p(this.leafPos[i]))) continue;
                    ++leafCount;
                }
                if (leafCount >= 3) {
                    Iterable area = BlockPos.func_218278_a((BlockPos)this.trunkPos, (BlockPos)this.trunkPos.func_177982_a(0, this.leafPos[0].func_177956_o() - this.trunkPos.func_177956_o(), 0));
                    for (BlockPos scan : area) {
                        Material material = this.field_145850_b.func_180495_p(scan).func_185904_a();
                        if (material != Material.field_151577_b && material != Material.field_151578_c && material != Material.field_151576_e) continue;
                        this.valid = false;
                        this.cached = true;
                        return;
                    }
                    area = BlockPos.func_218278_a((BlockPos)this.field_174879_c.func_177982_a(0, 1, 0), (BlockPos)this.field_174879_c.func_177982_a(0, this.leafPos[0].func_177956_o() - this.field_174879_c.func_177956_o(), 0));
                    for (BlockPos scan : area) {
                        if (!this.isTreeExtractor(this.field_145850_b.func_180495_p(scan))) continue;
                        this.valid = false;
                        this.cached = true;
                        return;
                    }
                    this.cached = true;
                    this.renderFluid = TreeExtractorManager.instance().getFluid(this.field_145850_b.func_180495_p(this.trunkPos));
                    return;
                }
            }
            this.valid = false;
        }
        if (this.isTrunkBase(this.field_174879_c.func_177976_e())) {
            this.trunkPos = this.field_174879_c.func_177976_e();
        } else if (this.isTrunkBase(this.field_174879_c.func_177974_f())) {
            this.trunkPos = this.field_174879_c.func_177974_f();
        } else if (this.isTrunkBase(this.field_174879_c.func_177978_c())) {
            this.trunkPos = this.field_174879_c.func_177978_c();
        } else if (this.isTrunkBase(this.field_174879_c.func_177968_d())) {
            this.trunkPos = this.field_174879_c.func_177968_d();
        }
        if (!this.isTrunkBase(this.trunkPos)) {
            this.valid = false;
            this.cached = true;
            return;
        }
        leafSet = TreeExtractorManager.instance().getMatchingLeaves(this.field_145850_b.func_180495_p(this.trunkPos));
        leafCount = 0;
        Iterable area = BlockPos.func_218281_b((BlockPos)this.field_174879_c.func_177982_a(-1, 0, -1), (BlockPos)this.field_174879_c.func_177982_a(1, Math.min(256 - this.field_174879_c.func_177956_o(), 40), 1)).map(BlockPos::func_185334_h).collect(Collectors.toList());
        for (BlockPos scan : area) {
            if (!leafSet.contains(this.field_145850_b.func_180495_p(scan))) continue;
            this.leafPos[leafCount] = new BlockPos((Vector3i)scan);
            if (++leafCount < 3) continue;
            break;
        }
        if (leafCount >= 3) {
            area = BlockPos.func_218278_a((BlockPos)this.trunkPos, (BlockPos)this.trunkPos.func_177982_a(0, this.leafPos[0].func_177956_o() - this.trunkPos.func_177956_o(), 0));
            for (BlockPos scan : area) {
                Material material = this.field_145850_b.func_180495_p(scan).func_185904_a();
                if (material != Material.field_151577_b && material != Material.field_151578_c && material != Material.field_151576_e) continue;
                this.valid = false;
                this.cached = true;
                return;
            }
            area = BlockPos.func_218278_a((BlockPos)this.field_174879_c.func_177982_a(0, 1, 0), (BlockPos)this.field_174879_c.func_177982_a(0, this.leafPos[0].func_177956_o() - this.field_174879_c.func_177956_o(), 0));
            for (BlockPos scan : area) {
                if (!this.isTreeExtractor(this.field_145850_b.func_180495_p(scan))) continue;
                this.valid = false;
                this.cached = true;
                return;
            }
            this.valid = true;
            this.renderFluid = TreeExtractorManager.instance().getFluid(this.field_145850_b.func_180495_p(this.trunkPos));
        }
        this.cached = true;
    }

    @Override
    protected void updateActiveState() {
        if (!this.cached) {
            this.updateValidity();
        }
        super.updateActiveState();
    }

    @Override
    protected boolean isValid() {
        return this.valid;
    }

    public void func_73660_a() {
        this.updateActiveState();
        --this.process;
        if (this.process > 0) {
            return;
        }
        this.updateValidity();
        this.process = this.getTimeConstant();
        if (!this.isActive) {
            return;
        }
        Fluid curFluid = this.renderFluid.getFluid();
        if (this.valid) {
            if (this.boostCycles > 0) {
                --this.boostCycles;
            } else if (!this.inputSlot.isEmpty()) {
                this.boostMax = this.boostCycles = TreeExtractorManager.instance().getBoostCycles(this.inputSlot.getItemStack());
                this.boostMult = TreeExtractorManager.instance().getBoostOutputMod(this.inputSlot.getItemStack());
                this.inputSlot.consume(1);
            } else {
                this.boostCycles = 0;
                this.boostMult = 1.0f;
            }
            this.outputTank.fill(new FluidStack(this.renderFluid, (int)((float)this.renderFluid.getAmount() * this.baseMod * this.boostMult)), IFluidHandler.FluidAction.EXECUTE);
        }
        if (curFluid != this.renderFluid.getFluid()) {
            TileStatePacket.sendToClient((ITilePacketHandler)this);
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ModelUtils.FLUID, (Object)this.renderFluid).build();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new DeviceTreeExtractorContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    @Override
    public int getScaledDuration(int scale) {
        return !this.isActive || this.boostCycles <= 0 || this.boostMax <= 0 ? 0 : scale * this.boostCycles / this.boostMax;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public void handleControlPacket(PacketBuffer buffer) {
        super.handleControlPacket(buffer);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public PacketBuffer getGuiPacket(PacketBuffer buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.boostCycles);
        buffer.writeInt(this.boostMax);
        buffer.writeFloat(this.boostMult);
        return buffer;
    }

    @Override
    public void handleGuiPacket(PacketBuffer buffer) {
        super.handleGuiPacket(buffer);
        this.boostCycles = buffer.readInt();
        this.boostMax = buffer.readInt();
        this.boostMult = buffer.readFloat();
    }

    @Override
    public PacketBuffer getStatePacket(PacketBuffer buffer) {
        super.getStatePacket(buffer);
        buffer.writeInt(this.process);
        return buffer;
    }

    @Override
    public void handleStatePacket(PacketBuffer buffer) {
        super.handleStatePacket(buffer);
        this.process = buffer.readInt();
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.boostCycles = nbt.func_74762_e("BoostCycles");
        this.boostMax = nbt.func_74762_e("BoostMax");
        this.boostMult = nbt.func_74760_g("BoostMult");
        this.process = nbt.func_74762_e("Proc");
        for (int i = 0; i < 3; ++i) {
            this.leafPos[i] = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("Leaf" + i));
        }
        this.trunkPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("Trunk"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("BoostCycles", this.boostCycles);
        nbt.func_74768_a("BoostMax", this.boostMax);
        nbt.func_74776_a("BoostMult", this.boostMult);
        nbt.func_74768_a("Proc", this.process);
        for (int i = 0; i < 3; ++i) {
            nbt.func_218657_a("Leaf" + i, (INBT)NBTUtil.func_186859_a((BlockPos)this.leafPos[i]));
        }
        nbt.func_218657_a("Trunk", (INBT)NBTUtil.func_186859_a((BlockPos)this.trunkPos));
        return nbt;
    }

    protected int getTimeConstant() {
        if (this.field_145850_b == null) {
            return timeConstant;
        }
        int constant = timeConstant / 2;
        Iterable area = BlockPos.func_218278_a((BlockPos)this.trunkPos.func_177982_a(-1, 0, -1), (BlockPos)this.trunkPos.func_177982_a(1, 0, 1));
        for (BlockPos scan : area) {
            if (!this.isTreeExtractor(this.field_145850_b.func_180495_p(scan))) continue;
            constant += timeConstant / 2;
        }
        return MathHelper.clamp((int)constant, (int)timeConstant, (int)(timeConstant * 2));
    }

    protected boolean isTrunkBase(BlockPos checkPos) {
        BlockState state = this.field_145850_b.func_180495_p(checkPos.func_177977_b());
        Material material = state.func_185904_a();
        if (material != Material.field_151577_b && material != Material.field_151578_c && material != Material.field_151576_e) {
            return false;
        }
        return TreeExtractorManager.instance().validTrunk(this.field_145850_b.func_180495_p(checkPos)) && TreeExtractorManager.instance().validTrunk(this.field_145850_b.func_180495_p(checkPos.func_177984_a())) && TreeExtractorManager.instance().validTrunk(this.field_145850_b.func_180495_p(checkPos.func_177981_b(2)));
    }

    protected boolean isTreeExtractor(BlockState state) {
        return state.func_177230_c() == this.func_195044_w().func_177230_c();
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }
}

