/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.network.client.message;

import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.puzzleslib.network.v2.message.Message;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class C2SAddEnchantLevelMessage
implements Message {
    private int containerId;
    private Enchantment enchantment;
    private boolean increase;

    public C2SAddEnchantLevelMessage() {
    }

    public C2SAddEnchantLevelMessage(int containerId, Enchantment enchantment, boolean increase) {
        this.containerId = containerId;
        this.enchantment = enchantment;
        this.increase = increase;
    }

    public void write(PacketBuffer buf) {
        buf.writeByte(this.containerId);
        buf.writeInt(((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((IForgeRegistryEntry)this.enchantment));
        buf.writeBoolean(this.increase);
    }

    public void read(PacketBuffer buf) {
        this.containerId = buf.readByte();
        this.enchantment = (Enchantment)((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(buf.readInt());
        this.increase = buf.readBoolean();
    }

    public EnchantmentLevelHandler makeHandler() {
        return new EnchantmentLevelHandler();
    }

    private static class EnchantmentLevelHandler
    extends Message.PacketHandler<C2SAddEnchantLevelMessage> {
        private EnchantmentLevelHandler() {
        }

        public void handle(C2SAddEnchantLevelMessage packet, PlayerEntity player, Object gameInstance) {
            if (player.field_71070_bA.field_75152_c == packet.containerId && player.field_71070_bA instanceof InfuserMenu) {
                ((InfuserMenu)player.field_71070_bA).clickEnchantmentButton(packet.enchantment, packet.increase);
            }
        }
    }
}

