/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.structure;

import com.terraforged.engine.cell.Cell;
import com.terraforged.mod.biome.provider.TFBiomeProvider;
import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.chunk.generator.StructureGenerator;
import com.terraforged.mod.structure.StructureSearchChunk;
import com.terraforged.mod.util.quadsearch.Search;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;

public class StructureSearch
implements Search<BlockPos> {
    protected final long seed;
    private final BlockPos pos;
    private final boolean skipExisting;
    private final Structure<?> structure;
    private final StructureSeparationSettings settings;
    private final TFBiomeProvider biomeProvider;
    private final ThreadLocal<ThreadResource> resource;
    private final AtomicReference<Throwable> errors = new AtomicReference();

    public StructureSearch(BlockPos center, boolean skipExisting, Structure<?> structure, StructureSeparationSettings settings, ServerWorld world, TFChunkGenerator generator) {
        this(center, skipExisting, structure, settings, generator.getBiomeSource(), () -> new FastThreadResource(world, generator));
    }

    public StructureSearch(BlockPos center, boolean skipExisting, Structure<?> structure, StructureSeparationSettings settings, IWorld world, TFChunkGenerator generator) {
        this(center, skipExisting, structure, settings, generator.getBiomeSource(), () -> new ThreadResource(world));
    }

    public StructureSearch(BlockPos center, boolean skipExisting, Structure<?> structure, StructureSeparationSettings settings, TFBiomeProvider biomeProvider, Supplier<ThreadResource> resourceSupplier) {
        this.seed = biomeProvider.getContext().worldSeed;
        this.pos = center;
        this.skipExisting = skipExisting;
        this.structure = structure;
        this.settings = settings;
        this.biomeProvider = biomeProvider;
        this.resource = ThreadLocal.withInitial(resourceSupplier);
    }

    public StructureSearch reset() {
        this.errors.set(null);
        return this;
    }

    @Override
    public final BlockPos result() {
        return this.resource.get().drainResult();
    }

    @Override
    public Throwable error() {
        return this.errors.get();
    }

    @Override
    public final int compare(BlockPos a, BlockPos b) {
        return Double.compare(a.func_177951_i((Vector3i)this.pos), b.func_177951_i((Vector3i)this.pos));
    }

    @Override
    public final boolean test(int chunkX, int chunkZ) {
        ThreadResource resource = this.resource.get();
        try {
            ChunkPos pos = this.structure.func_236392_a_(this.settings, this.seed, resource.random, chunkX, chunkZ);
            int biomeX = StructureGenerator.chunkToBiomeChunkCenter(pos.field_77276_a);
            int biomeZ = StructureGenerator.chunkToBiomeChunkCenter(pos.field_77275_b);
            Biome biome = this.biomeProvider.getNoiseBiome(resource.cell.reset(), biomeX, biomeZ);
            if (!biome.func_242440_e().func_242493_a(this.structure)) {
                return false;
            }
            IChunk chunk = resource.getChunk(pos);
            StructureStart start = (StructureStart)chunk.func_201609_c().get(this.structure);
            if (start != null && start.func_75069_d()) {
                if (this.skipExisting && start.func_75069_d()) {
                    start.func_212685_h();
                    resource.setResult(start.func_204294_a());
                    return true;
                }
                if (!this.skipExisting) {
                    resource.setResult(start.func_204294_a());
                    return true;
                }
            }
        }
        catch (Throwable t) {
            this.errors.set(t);
            resource.setResult(null);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.resource.remove();
    }

    private static class FastThreadResource
    extends ThreadResource {
        private final ServerWorld world;
        private final TFChunkGenerator generator;
        private final StructureSearchChunk searchChunk = new StructureSearchChunk();

        private FastThreadResource(ServerWorld world, TFChunkGenerator generator) {
            super((IWorld)world);
            this.world = world;
            this.generator = generator;
        }

        @Override
        protected IChunk getChunk(ChunkPos pos) {
            DynamicRegistries registries = this.world.func_241828_r();
            StructureManager manager = this.world.func_241112_a_();
            TemplateManager templates = this.world.func_184163_y();
            StructureSearchChunk chunk = this.searchChunk.init(pos);
            this.generator.getStructureGenerator().generateStructureStarts((IChunk)chunk, registries, manager, templates);
            return chunk;
        }
    }

    private static class ThreadResource {
        private final IWorld world;
        private final Cell cell = new Cell();
        private final SharedSeedRandom random = new SharedSeedRandom();
        private BlockPos result = null;

        private ThreadResource(IWorld world) {
            this.world = world;
        }

        protected IChunk getChunk(ChunkPos pos) {
            return this.world.func_217348_a(pos.field_77276_a, pos.field_77275_b, ChunkStatus.field_222606_b);
        }

        protected void setResult(BlockPos pos) {
            this.result = pos;
        }

        protected BlockPos drainResult() {
            BlockPos value = this.result;
            this.result = null;
            return value;
        }
    }
}

