/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.profiler.watchdog;

import com.terraforged.engine.concurrent.thread.ThreadPools;
import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.config.ConfigManager;
import com.terraforged.mod.profiler.Profiler;
import com.terraforged.mod.profiler.crash.CrashHandler;
import com.terraforged.mod.profiler.crash.WorldGenException;
import com.terraforged.mod.profiler.watchdog.ChunkTimeoutException;
import com.terraforged.mod.profiler.watchdog.ContextQueue;
import com.terraforged.mod.profiler.watchdog.WarnTimer;
import com.terraforged.mod.profiler.watchdog.WatchdogContext;
import com.terraforged.mod.profiler.watchdog.WatchdogCtx;
import net.minecraft.world.chunk.IChunk;

public class Watchdog
implements Runnable {
    public static final String FEATURE_WARN_KEY = "feature_warn_time";
    public static final String CHUNK_TIMEOUT_KEY = "chunkgen_timeout";
    public static final long DEFAULT_WARN_TIME_MS = 500L;
    public static final long DEFAULT_TIMEOUT_MS = 60000L;
    private static final long MIN_CRASH_TIME = 5000L;
    private static final long CHECK_INTERVAL = 5251L;
    private static final Watchdog INSTANCE = new Watchdog();
    private final ContextQueue contextQueue = new ContextQueue();
    private final ThreadLocal<WarnTimer> timerPool = ThreadLocal.withInitial(Watchdog::createWarnTimer);
    private final ThreadLocal<WatchdogContext> contextPool = ThreadLocal.withInitial(WatchdogCtx::new);

    @Override
    public void run() {
        try {
            WatchdogContext[] queue = this.contextQueue.get();
            if (queue.length > 0) {
                long now = System.currentTimeMillis();
                for (WatchdogContext context : queue) {
                    context.check(now);
                }
            }
        }
        catch (ChunkTimeoutException e) {
            e.printStackTrace();
            CrashHandler.handle(e.getChunk(), e.getGenerator(), (Throwable)new WorldGenException(Profiler.DECORATION, (Throwable)e));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static WatchdogContext punchIn(IChunk chunk, TFChunkGenerator generator, long duration) {
        WatchdogContext context;
        if (duration > 0L && (context = Watchdog.INSTANCE.contextPool.get()).set(chunk, generator, duration)) {
            return context;
        }
        return WatchdogContext.NONE;
    }

    public static WarnTimer getWarnTimer() {
        return Watchdog.INSTANCE.timerPool.get();
    }

    public static long getWatchdogHangTime() {
        long time = ConfigManager.GENERAL.load().getLong(CHUNK_TIMEOUT_KEY, 60000L);
        if (time <= 0L) {
            return -1L;
        }
        return Math.max(time, 5000L);
    }

    protected static void addContext(WatchdogContext context) {
        Watchdog.INSTANCE.contextQueue.add(context);
    }

    protected static WarnTimer createWarnTimer() {
        return new WarnTimer(ConfigManager.GENERAL.load().getLong(FEATURE_WARN_KEY, 500L));
    }

    static {
        ThreadPools.scheduleRepeat(INSTANCE, 5251L);
    }
}

