/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.matcher.feature;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.terraforged.engine.world.biome.map.BiomeContext;
import com.terraforged.mod.featuremanager.matcher.feature.Rule;
import com.terraforged.mod.featuremanager.matcher.feature.Search;
import com.terraforged.mod.featuremanager.modifier.Jsonifiable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FeatureMatcher
implements Predicate<JsonElement>,
Jsonifiable {
    public static final Predicate<JsonElement> ALLOW_ALL = json -> true;
    public static final Predicate<JsonElement> ALLOW_NONE = json -> false;
    public static final FeatureMatcher ANY = new FeatureMatcher(Collections.emptyList(), ALLOW_ALL);
    public static final FeatureMatcher NONE = new FeatureMatcher(Collections.emptyList(), ALLOW_NONE);
    protected final List<Rule> rules;
    protected final Predicate<JsonElement> filter;

    protected FeatureMatcher(List<Rule> rules) {
        this(rules, ALLOW_ALL);
    }

    protected FeatureMatcher(List<Rule> rules, Predicate<JsonElement> filter) {
        this.rules = rules;
        this.filter = filter;
    }

    @Override
    public String getType() {
        return "match";
    }

    @Override
    public JsonElement toJson(BiomeContext<?> context) {
        JsonArray rules = new JsonArray();
        for (Rule rule : this.rules) {
            rules.add(rule.toJson());
        }
        return rules;
    }

    @Override
    public boolean test(JsonElement element) {
        if (this == ANY) {
            return true;
        }
        if (this == NONE) {
            return false;
        }
        return this.test(element, this.createSearch());
    }

    public String toString() {
        return "JsonMatcher{rules=" + this.rules + '}';
    }

    public FeatureMatcher withFilter(Predicate<JsonElement> filter) {
        return new FeatureMatcher(this.rules, filter);
    }

    public FeatureMatcher withNamespace(String ... namespaces) {
        return this.withFilter(FeatureMatcher.namespaceFilter(namespaces));
    }

    protected boolean test(JsonElement element, Search search) {
        if (!this.filter.test(element)) {
            search.cancel();
            return false;
        }
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            for (Map.Entry e : object.entrySet()) {
                if (!this.testObjectEntry((String)e.getKey(), (JsonElement)e.getValue(), search)) continue;
                return search.isComplete();
            }
        } else if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                if (!this.testArrayEntry(i, array.get(i), search)) continue;
                return search.isComplete();
            }
        } else if (element.isJsonPrimitive()) {
            search.test(element.getAsJsonPrimitive());
            return search.isComplete();
        }
        return search.isComplete();
    }

    protected boolean testObjectEntry(String key, JsonElement element, Search search) {
        if (search.test(key, element)) {
            return search.isComplete();
        }
        return this.test(element, search);
    }

    protected boolean testArrayEntry(int index, JsonElement element, Search search) {
        return this.test(element, search);
    }

    protected Search createSearch() {
        return new Search(this.rules);
    }

    public static Optional<FeatureMatcher> of(JsonElement element) {
        List<Rule> rules = Rule.parseRules(element);
        if (rules.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new FeatureMatcher(rules));
    }

    public static Predicate<JsonElement> namespaceFilter(String ... namespaces) {
        return json -> {
            if (!json.isJsonPrimitive()) {
                return true;
            }
            String value = json.getAsString();
            int i = value.indexOf(58);
            if (i == -1) {
                return true;
            }
            for (String namespace : namespaces) {
                if (!value.regionMatches(0, namespace, 0, i)) continue;
                return true;
            }
            return false;
        };
    }

    public static FeatureMatcher of(Object arg) {
        return FeatureMatcher.and(arg);
    }

    public static FeatureMatcher or(Object ... args) {
        if (args.length == 0) {
            return ANY;
        }
        Builder builder = FeatureMatcher.builder();
        for (Object o : args) {
            builder.or(o);
        }
        return builder.build();
    }

    public static FeatureMatcher and(Object ... args) {
        if (args.length == 0) {
            return ANY;
        }
        Builder builder = FeatureMatcher.builder();
        for (Object arg : args) {
            builder.and(arg);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static JsonElement arg(Object arg) {
        if (arg instanceof String) {
            return new JsonPrimitive((String)arg);
        }
        if (arg instanceof Number) {
            return new JsonPrimitive((Number)arg);
        }
        if (arg instanceof Boolean) {
            return new JsonPrimitive((Boolean)arg);
        }
        if (arg instanceof ResourceLocation) {
            return new JsonPrimitive(arg.toString());
        }
        if (arg instanceof ForgeRegistryEntry) {
            return new JsonPrimitive(((ForgeRegistryEntry)arg).getRegistryName() + "");
        }
        return JsonNull.INSTANCE;
    }

    public static class Builder {
        protected Predicate<JsonElement> filter = ALLOW_ALL;
        protected List<Rule> rules = Collections.emptyList();
        protected List<JsonPrimitive> values = Collections.emptyList();
        protected Map<String, JsonElement> mappings = Collections.emptyMap();

        public Builder and(Object value) {
            JsonElement element = FeatureMatcher.arg(value);
            if (element.isJsonPrimitive()) {
                this.and(element.getAsJsonPrimitive());
            }
            return this;
        }

        public Builder and(Boolean value) {
            return this.and(new JsonPrimitive(value));
        }

        public Builder and(Number value) {
            return this.and(new JsonPrimitive(value));
        }

        public Builder and(String value) {
            return this.and(new JsonPrimitive(value));
        }

        public Builder and(JsonPrimitive value) {
            if (this.values.isEmpty()) {
                this.values = new ArrayList<JsonPrimitive>();
            }
            this.values.add(value);
            return this;
        }

        public Builder and(String key, JsonElement value) {
            if (this.mappings.isEmpty()) {
                this.mappings = new HashMap<String, JsonElement>();
            }
            this.mappings.put(key, value);
            return this;
        }

        public Builder or(Collection<Object> collection) {
            for (Object o : collection) {
                this.or(o);
            }
            return this;
        }

        public Builder or(Object value) {
            JsonElement element = FeatureMatcher.arg(value);
            if (element.isJsonPrimitive()) {
                this.or(element.getAsJsonPrimitive());
            }
            return this;
        }

        public Builder or(Boolean value) {
            return this.or(new JsonPrimitive(value));
        }

        public Builder or(Number value) {
            return this.or(new JsonPrimitive(value));
        }

        public Builder or(String value) {
            return this.or(new JsonPrimitive(value));
        }

        public Builder or(JsonPrimitive value) {
            return this.newRule().and(value);
        }

        public Builder or(String key, JsonElement value) {
            return this.newRule().and(key, value);
        }

        public Builder newRule() {
            if (!this.values.isEmpty() || !this.mappings.isEmpty()) {
                if (this.rules.isEmpty()) {
                    this.rules = new ArrayList<Rule>();
                }
                this.rules.add(new Rule(this.values, this.mappings));
                this.values = Collections.emptyList();
                this.mappings = Collections.emptyMap();
            }
            return this;
        }

        public Builder namespace(String ... namespaces) {
            this.filter = FeatureMatcher.namespaceFilter(namespaces);
            return this;
        }

        public FeatureMatcher build() {
            if (this.rules.isEmpty() && this.values.isEmpty()) {
                return NONE;
            }
            this.newRule();
            return new FeatureMatcher(this.rules, this.filter);
        }
    }
}

