/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.sapling;

import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.feature.BlockDataManager;
import com.terraforged.mod.feature.sapling.SaplingConfig;
import com.terraforged.mod.featuremanager.template.feature.TemplateFeature;
import com.terraforged.mod.featuremanager.template.feature.TemplateFeatureConfig;
import com.terraforged.mod.featuremanager.template.template.Template;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SaplingListener {
    private static final BlockPos[] CENTER = new BlockPos[]{BlockPos.field_177992_a};
    private static final Vector3i[][] DIRECTIONS = new Vector3i[][]{{new Vector3i(0, 0, 1), new Vector3i(1, 0, 1), new Vector3i(1, 0, 0)}, {new Vector3i(1, 0, 0), new Vector3i(1, 0, -1), new Vector3i(0, 0, -1)}, {new Vector3i(0, 0, -1), new Vector3i(-1, 0, -1), new Vector3i(-1, 0, 0)}, {new Vector3i(-1, 0, 0), new Vector3i(-1, 0, 1), new Vector3i(0, 0, 1)}};

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTreeGrow(SaplingGrowTreeEvent event) {
        Optional<BlockDataManager> dataManager = SaplingListener.getDataManger(event);
        if (!dataManager.isPresent()) {
            return;
        }
        ISeedReader world = (ISeedReader)event.getWorld();
        Block block = world.func_180495_p(event.getPos()).func_177230_c();
        Optional<SaplingConfig> saplingConfig = dataManager.get().getConfig(block, SaplingConfig.class);
        if (!saplingConfig.isPresent()) {
            return;
        }
        Mirror mirror = TemplateFeature.nextMirror(event.getRand());
        Rotation rotation = TemplateFeature.nextRotation(event.getRand());
        BlockPos pos = SaplingListener.getMinPos((IWorld)world, block, event.getPos(), saplingConfig.get().hasGiant());
        Vector3i[] directions = SaplingListener.getNeighbours((IWorld)world, block, pos, saplingConfig.get().hasGiant());
        TemplateFeatureConfig feature = saplingConfig.get().next(event.getRand(), directions.length == 3);
        if (feature == null) {
            return;
        }
        Vector3i translation = SaplingListener.getTranslation(directions, mirror, rotation);
        BlockPos origin = pos.func_177973_b(translation);
        boolean flowers = SaplingListener.hasFlowers((IWorld)world, origin);
        event.setResult(Event.Result.DENY);
        if (TemplateFeature.paste(world, event.getRand(), origin, mirror, rotation, feature, feature.decorator, Template.CHECKED, flowers)) {
            for (Vector3i dir : directions) {
                BlockPos neighbour = origin.func_177971_a(dir);
                BlockState state = world.func_180495_p(neighbour);
                if (state.func_177230_c() != block) continue;
                world.func_175655_b(neighbour, false);
            }
        }
    }

    private static Optional<BlockDataManager> getDataManger(SaplingGrowTreeEvent event) {
        if (event.getWorld().func_201670_d()) {
            return Optional.empty();
        }
        if (!SaplingListener.isTerraGen(event.getWorld())) {
            return Optional.empty();
        }
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            ChunkGenerator generator = serverWorld.func_72863_F().field_186029_c;
            if (generator instanceof TFChunkGenerator) {
                TerraContext context = ((TFChunkGenerator)generator).getContext();
                if (context.terraSettings.miscellaneous.customBiomeFeatures) {
                    return Optional.of(((TFChunkGenerator)generator).getBlockDataManager());
                }
            }
        }
        return Optional.empty();
    }

    private static boolean isTerraGen(IWorld world) {
        if (world.func_72863_F() instanceof ServerChunkProvider) {
            ServerChunkProvider chunkProvider = (ServerChunkProvider)world.func_72863_F();
            return chunkProvider.func_201711_g() instanceof TFChunkGenerator;
        }
        return false;
    }

    private static boolean isClearOverhead(IWorld world, BlockPos pos, Vector3i[] directions) {
        for (Vector3i dir : directions) {
            int z;
            int x = pos.func_177958_n() + dir.func_177958_n();
            int y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z = pos.func_177952_p() + dir.func_177952_p());
            if (y <= pos.func_177956_o()) continue;
            return false;
        }
        return true;
    }

    private static BlockPos getMinPos(IWorld world, Block block, BlockPos pos, boolean checkNeighbours) {
        if (checkNeighbours) {
            for (Vector3i[] dirs : DIRECTIONS) {
                boolean match = true;
                for (Vector3i dir : dirs) {
                    BlockState state = world.func_180495_p(pos.func_177971_a(dir));
                    if (state.func_177230_c() == block) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                Vector3i min = SaplingListener.getMin(dirs, Mirror.NONE, Rotation.NONE);
                return pos.func_177971_a(min);
            }
        }
        return pos;
    }

    private static boolean hasFlowers(IWorld world, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.Mutable.func_218278_a((BlockPos)pos.func_177977_b().func_177964_d(2).func_177985_f(2), (BlockPos)pos.func_177984_a().func_177970_e(2).func_177965_g(2))) {
            if (!world.func_180495_p(blockpos).func_235714_a_((ITag)BlockTags.field_226149_I_)) continue;
            return true;
        }
        return false;
    }

    private static Vector3i getTranslation(Vector3i[] directions, Mirror mirror, Rotation rotation) {
        if (directions.length == 1 || mirror == Mirror.NONE && rotation == Rotation.NONE) {
            return Vector3i.field_177959_e;
        }
        return SaplingListener.getMin(directions, mirror, rotation);
    }

    private static Vector3i getMin(Vector3i[] directions, Mirror mirror, Rotation rotation) {
        int minX = 0;
        int minZ = 0;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (Vector3i vec : directions) {
            BlockPos dir = Template.transform((BlockPos)pos.func_189533_g(vec), mirror, rotation);
            minX = Math.min(dir.func_177958_n(), minX);
            minZ = Math.min(dir.func_177952_p(), minZ);
        }
        return new Vector3i(minX, 0, minZ);
    }

    private static Vector3i[] getNeighbours(IWorld world, Block block, BlockPos pos, boolean checkNeighbours) {
        if (checkNeighbours) {
            for (Vector3i[] dirs : DIRECTIONS) {
                boolean match = true;
                for (Vector3i dir : dirs) {
                    BlockState state = world.func_180495_p(pos.func_177971_a(dir));
                    if (state.func_177230_c() == block) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return dirs;
            }
        }
        return CENTER;
    }
}

