/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.decorator.poisson;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.terraforged.engine.tile.chunk.ChunkReader;
import com.terraforged.mod.api.feature.decorator.DecorationContext;
import com.terraforged.mod.feature.decorator.poisson.BiomeVariance;
import com.terraforged.mod.feature.decorator.poisson.DensityNoise;
import com.terraforged.mod.featuremanager.util.codec.Codecs;
import com.terraforged.noise.Module;
import com.terraforged.noise.Source;
import com.terraforged.noise.util.NoiseUtil;
import java.util.Map;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.gen.placement.IPlacementConfig;

public class FastPoissonConfig
implements IPlacementConfig {
    public static final float DEFAULT_JITTER = 0.8f;
    public static final Codec<FastPoissonConfig> CODEC = Codecs.create(FastPoissonConfig::serialize, FastPoissonConfig::deserialize);
    public final int radius;
    public final float scale;
    public final float jitter;
    public final float biomeFade;
    public final float densityVariation;
    public final int densityVariationScale;

    public FastPoissonConfig(float scale, int radius, float biomeFade, int densityScale, float densityVariation) {
        this(scale, 0.8f, radius, biomeFade, densityScale, densityVariation);
    }

    public FastPoissonConfig(float scale, float jitter, int radius, float biomeFade, int densityScale, float densityVariation) {
        this.scale = scale;
        this.jitter = jitter;
        this.radius = radius;
        this.biomeFade = biomeFade;
        this.densityVariationScale = densityScale;
        this.densityVariation = NoiseUtil.clamp(densityVariation, 0.0f, 1.0f);
    }

    public DensityNoise getDensityNoise(int seed, DecorationContext context) {
        Module densityVariance = Source.ONE;
        BiomeVariance biomeVariance = BiomeVariance.NONE;
        if (this.biomeFade > 0.025f) {
            ChunkPos pos = context.getChunk().func_76632_l();
            ChunkReader reader = context.getGenerator().getChunkReader(pos.field_77276_a, pos.field_77275_b);
            if (reader != null) {
                biomeVariance = new BiomeVariance(reader, this.biomeFade);
            }
        }
        if (this.densityVariation > 0.0f) {
            densityVariance = Source.simplex(seed + 1, this.densityVariationScale, 1).scale(this.densityVariation).bias(1.0f - this.densityVariation);
        }
        return new DensityNoise(biomeVariance, densityVariance);
    }

    private static <T> Dynamic<T> serialize(FastPoissonConfig config, DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("radius"), ops.createInt(config.radius));
        builder.put(ops.createString("scale"), ops.createFloat(config.scale));
        builder.put(ops.createString("jitter"), ops.createFloat(config.jitter));
        builder.put(ops.createString("biome_fade"), ops.createFloat(config.biomeFade));
        builder.put(ops.createString("density_scale"), ops.createInt(config.densityVariationScale));
        builder.put(ops.createString("density_variation"), ops.createFloat(config.densityVariation));
        return new Dynamic(ops, ops.createMap((Map)builder.build()));
    }

    private static <T> FastPoissonConfig deserialize(Dynamic<T> dynamic) {
        int radius = dynamic.get("radius").asInt(4);
        float scale = dynamic.get("scale").asFloat(0.1f);
        float jitter = dynamic.get("jitter").asFloat(0.8f);
        float biomeFade = dynamic.get("biome_fade").asFloat(0.2f);
        int densityScale = dynamic.get("density_scale").asInt(0);
        float densityVariation = dynamic.get("density_variation").asFloat(0.0f);
        return new FastPoissonConfig(scale, jitter, radius, biomeFade, densityScale, densityVariation);
    }
}

