/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data.gen.feature;

import com.terraforged.mod.data.gen.FeatureInjectorProvider;
import com.terraforged.mod.featuremanager.matcher.biome.BiomeMatcher;
import com.terraforged.mod.featuremanager.matcher.feature.FeatureMatcher;
import com.terraforged.mod.featuremanager.transformer.FeatureTransformer;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.Feature;

public class Ores {
    public static void addInjectors(FeatureInjectorProvider provider) {
        provider.addTFVanilla("ores/coal", FeatureMatcher.and(Blocks.field_150365_q, Feature.field_202290_aj), Ores.scaledOre(140, 128, 20));
        provider.addTFVanilla("ores/iron", FeatureMatcher.and(Blocks.field_150366_p, Feature.field_202290_aj), Ores.scaledOre(100, 64, 24));
        provider.addTFVanilla("ores/gold", FeatureMatcher.and(Blocks.field_150352_o, Feature.field_202290_aj, 2), Ores.scaledOre(35, 32, 2));
        provider.addTFVanilla("ores/redstone", FeatureMatcher.and(Blocks.field_150450_ax, Feature.field_202290_aj), Ores.scaledOre(18, 16, 8));
        provider.addTFVanilla("ores/diamond", FeatureMatcher.and(Blocks.field_150482_ag, Feature.field_202290_aj), FeatureTransformer.key("maximum", 18));
        provider.add("ores/gold_extra", BiomeMatcher.of(provider.getContext(), Biome.Category.MESA), FeatureMatcher.and(Blocks.field_150352_o, Feature.field_202290_aj, 20), FeatureTransformer.builder().key("bottom_offset", 35).key("top_offset", 35).key("maximum", 100).key("count", Ores.volumeScale(35, 100, 32, 80, 20)).build());
    }

    private static FeatureTransformer scaledOre(int newHeight, int vanillaHeight, int vanillaCount) {
        int newCount = Ores.volumeScale(0, newHeight, 0, vanillaHeight, vanillaCount);
        return FeatureTransformer.builder().key("maximum", newHeight).key("count", newCount).build();
    }

    private static int volumeScale(int newMin, int newMax, int oldMin, int oldMax, int vanillaCount) {
        float newVolume = (newMax - newMin) * 16 * 16;
        float oldVolume = (oldMax - oldMin) * 16 * 16;
        float scale = newVolume / oldVolume;
        return Math.round((float)vanillaCount * scale);
    }
}

