/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.generator;

import com.google.common.collect.ImmutableSet;
import com.terraforged.engine.concurrent.task.LazySupplier;
import com.terraforged.mod.biome.provider.TFBiomeProvider;
import com.terraforged.mod.chunk.generator.Generator;
import com.terraforged.mod.chunk.settings.StructureSettings;
import com.terraforged.noise.util.Vec2i;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.Structure;

public class StrongholdGenerator
implements Generator.Strongholds {
    private static final ChunkPos[] EMPTY_ARRAY = new ChunkPos[0];
    private final long seed;
    private final int salt;
    private final int count;
    private final int spread;
    private final int distance;
    private final boolean disabled;
    private final boolean constrain;
    private final Vec2i origin;
    private final TFBiomeProvider biomeProvider;
    private final LazySupplier<ChunkPos[]> positions;
    private final LazySupplier<Set<ChunkPos>> lookup;

    public StrongholdGenerator(long seed, TFBiomeProvider biomeProvider) {
        this.seed = seed;
        this.origin = new Vec2i(0, 0);
        this.biomeProvider = biomeProvider;
        this.positions = LazySupplier.of(this::generate);
        this.lookup = this.positions.then(ImmutableSet::copyOf);
        this.salt = StrongholdGenerator.getStrongholdSetting(biomeProvider, s -> s.salt);
        this.count = StrongholdGenerator.getStrongholdSetting(biomeProvider, s -> s.count);
        this.spread = StrongholdGenerator.getStrongholdSetting(biomeProvider, s -> s.spread);
        this.distance = StrongholdGenerator.getStrongholdSetting(biomeProvider, s -> s.distance);
        this.disabled = biomeProvider.getContext().terraSettings.structures.stronghold.disabled;
        this.constrain = biomeProvider.getContext().terraSettings.structures.stronghold.constrainToBiomes;
    }

    @Override
    public boolean isStrongholdChunk(ChunkPos pos) {
        return !this.disabled && ((Set)this.lookup.get()).contains(pos);
    }

    @Override
    public BlockPos findNearestStronghold(BlockPos pos) {
        ChunkPos[] chunks;
        if (this.disabled) {
            return null;
        }
        double distance2 = Double.MAX_VALUE;
        BlockPos.Mutable nearest = null;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (ChunkPos chunkpos : chunks = (ChunkPos[])this.positions.get()) {
            mutable.func_181079_c((chunkpos.field_77276_a << 4) + 8, 32, (chunkpos.field_77275_b << 4) + 8);
            double dist2 = mutable.func_177951_i((Vector3i)pos);
            if (nearest == null) {
                nearest = new BlockPos.Mutable();
                nearest.func_189533_g((Vector3i)mutable);
                distance2 = dist2;
                continue;
            }
            if (!(dist2 < distance2)) continue;
            nearest.func_189533_g((Vector3i)mutable);
            distance2 = dist2;
        }
        if (nearest != null) {
            return nearest.func_185334_h();
        }
        return null;
    }

    private ChunkPos[] generate() {
        if (this.disabled) {
            return EMPTY_ARRAY;
        }
        if (this.count > 0 && this.spread > 0 && this.distance > 0) {
            int originX = this.origin.x;
            int originZ = this.origin.y;
            int count = this.count;
            int spread = this.spread;
            int distance = this.distance;
            TFBiomeProvider biomeProvider = this.biomeProvider;
            Predicate<Biome> biomePredicate = StrongholdGenerator.getStrongholdBiomes(biomeProvider);
            int chunkX = 0;
            int chunkZ = 0;
            Random random = new Random(this.salt);
            double angle = random.nextDouble() * Math.PI * 2.0;
            ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
            for (int i = 0; i < count; ++i) {
                int z;
                int chunkCenterZ;
                double pos = (double)(4 * distance + distance * chunkZ * 6) + (random.nextDouble() - 0.5) * (double)distance * 2.5;
                int x = originX + (int)Math.round(Math.cos(angle) * pos);
                int chunkCenterX = (x << 4) + 8;
                BlockPos blockpos = biomeProvider.func_225531_a_(chunkCenterX, 0, chunkCenterZ = ((z = originZ + (int)Math.round(Math.sin(angle) * pos)) << 4) + 8, 112, biomePredicate, random);
                if (blockpos != null) {
                    x = blockpos.func_177958_n() >> 4;
                    z = blockpos.func_177952_p() >> 4;
                }
                if (blockpos != null || !this.constrain) {
                    chunks.add(new ChunkPos(x, z));
                }
                angle += Math.PI * 2 / (double)spread;
                if (++chunkX != spread) continue;
                chunkX = 0;
                spread += 2 * spread / (++chunkZ + 1);
                spread = Math.min(spread, count - i);
                angle += random.nextDouble() * Math.PI * 2.0;
            }
            return chunks.toArray(EMPTY_ARRAY);
        }
        return EMPTY_ARRAY;
    }

    private static Predicate<Biome> getStrongholdBiomes(TFBiomeProvider biomeProvider) {
        HashSet<Biome> biomes = new HashSet<Biome>();
        for (Biome biome : biomeProvider.func_235203_c_()) {
            if (!biome.func_242440_e().func_242493_a(Structure.field_236375_k_)) continue;
            biomes.add(biome);
        }
        return biomes::contains;
    }

    private static int getStrongholdSetting(TFBiomeProvider biomeProvider, ToIntFunction<StructureSettings.StructureSpread> func) {
        StructureSettings.StructureSpread settings = biomeProvider.getSettings().structures.stronghold;
        if (settings.disabled) {
            return -1;
        }
        return func.applyAsInt(settings);
    }
}

