/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.fix;

import com.terraforged.mod.api.chunk.ChunkDelegate;
import com.terraforged.mod.api.material.state.States;
import com.terraforged.mod.material.Materials;
import java.util.BitSet;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;

public class ChunkCarverFix
extends ChunkDelegate {
    private final int maskDepth;
    private final Materials materials;

    public ChunkCarverFix(IChunk chunk, Materials materials, boolean nearStructure, boolean nearRiver) {
        super(chunk);
        this.materials = materials;
        this.maskDepth = nearRiver ? 15 : (nearStructure ? 5 : -1);
    }

    public BitSet getCarvingMask(GenerationStage.Carving type) {
        return ((ChunkPrimer)this.delegate).func_230345_b_(type);
    }

    @Override
    public BlockState func_180495_p(BlockPos pos) {
        BlockState state = this.delegate.func_180495_p(pos);
        if (this.materials.isAir(state.func_177230_c())) {
            return state;
        }
        if (this.materials.isGrass(state.func_177230_c())) {
            return (BlockState)States.GRASS_BLOCK.get();
        }
        if (this.materials.isStone(state.func_177230_c())) {
            return (BlockState)States.STONE.get();
        }
        if (this.materials.isEarth(state.func_177230_c())) {
            return (BlockState)States.DIRT.get();
        }
        if (this.materials.isClay(state.func_177230_c())) {
            return (BlockState)States.DIRT.get();
        }
        if (this.materials.isSediment(state.func_177230_c())) {
            return (BlockState)States.SAND.get();
        }
        return state;
    }

    @Override
    public BlockState func_177436_a(BlockPos pos, BlockState state, boolean isMoving) {
        if (this.maskDepth != -1) {
            int surface = this.delegate.func_201576_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n(), pos.func_177952_p());
            if (pos.func_177956_o() > surface - this.maskDepth) {
                return state;
            }
        }
        return this.delegate.func_177436_a(pos, state, isMoving);
    }
}

