/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.surface;

import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.world.biome.DesertBiomes;
import com.terraforged.engine.world.heightmap.Levels;
import com.terraforged.mod.api.biome.surface.MaskedSurface;
import com.terraforged.mod.api.biome.surface.Surface;
import com.terraforged.mod.api.biome.surface.SurfaceContext;
import com.terraforged.mod.api.material.layer.LayerManager;
import com.terraforged.mod.api.material.layer.LayerMaterial;
import com.terraforged.mod.biome.provider.TFBiomeProvider;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.noise.Module;
import com.terraforged.noise.Source;
import com.terraforged.noise.func.CellFunc;
import com.terraforged.noise.util.NoiseUtil;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.Heightmap;

public class DunesSurface
implements MaskedSurface {
    private final int maxHeight;
    private final Levels levels;
    private final Module module;
    private final LayerManager layers;
    private final BlockPos.Mutable pos = new BlockPos.Mutable();

    public DunesSurface(TerraContext context, int maxHeight, LayerManager deserts) {
        Module dunes = Source.cell(context.seed.next(), 80, CellFunc.DISTANCE).warp(context.seed.next(), 70, 1, 70.0);
        this.levels = context.levels;
        this.maxHeight = maxHeight;
        this.layers = deserts;
        this.module = dunes;
    }

    @Override
    public float getMask(Cell cell) {
        return NoiseUtil.map(cell.biomeRegionEdge, 0.0f, 0.7f, 0.7f) * NoiseUtil.map(cell.riverMask, 0.5f, 0.95f, 0.45f);
    }

    @Override
    public void buildSurface(int x, int z, int surface, float mask, SurfaceContext ctx) {
        float value = this.module.getValue(0, x, z) * mask;
        float baseHeight = ctx.chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, x & 0xF, z & 0xF);
        float duneHeight = baseHeight + value * (float)this.maxHeight;
        int duneBase = (int)baseHeight;
        int duneTop = (int)duneHeight + 1;
        if (duneTop < this.levels.waterLevel || (float)duneTop <= baseHeight) {
            return;
        }
        LayerMaterial material = null;
        if (material == null) {
            this.fill(x, z, duneBase - 4, duneTop, ctx, ctx.chunk, Blocks.field_150354_m.func_176223_P());
            return;
        }
        this.fill(x, z, duneBase, duneTop, ctx, ctx.chunk, material.getFull());
        float depth = material.getDepth(duneHeight);
        int levels = material.getLevel(depth);
        BlockState top = material.getState(levels);
        ctx.chunk.func_177436_a((BlockPos)this.pos.func_181079_c(x, duneTop, z), top, false);
    }

    public static Surface create(TerraContext context, TFBiomeProvider provider) {
        return DunesSurface.create(context, provider.getModifierManager().getDesertBiomes());
    }

    public static Surface create(TerraContext context, DesertBiomes desertBiomes) {
        return new DunesSurface(context, 25, null);
    }
}

