/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.provider.analyser;

import com.terraforged.mod.biome.context.TFBiomeContext;
import java.util.function.BiPredicate;
import net.minecraft.world.biome.Biome;

public interface BiomePredicate {
    public static final float ANY_MIN = -3.4028235E38f;
    public static final float ANY_MAX = Float.MAX_VALUE;
    public static final float FROZEN = -0.4f;
    public static final float COLD = 0.2f;
    public static final float WARM = 1.4f;
    public static final float HOT = 1.7f;
    public static final float LIGHT = 0.2f;
    public static final float MODERATE = 0.4f;
    public static final float HEAVY = 0.8f;
    public static final BiomePredicate OCEAN = BiomePredicate.type(Biome.Category.OCEAN);
    public static final BiomePredicate BEACH = BiomePredicate.type(Biome.Category.BEACH).or(BiomePredicate.name("beach", "shore"));
    public static final BiomePredicate COAST = BiomePredicate.type(Biome.Category.MUSHROOM).or(BiomePredicate.name("coast"));
    public static final BiomePredicate COLD_STEPPE = BiomePredicate.name("steppe").and(BiomePredicate.temp(-3.4028235E38f, 0.2f));
    public static final BiomePredicate DESERT = BiomePredicate.type(Biome.Category.DESERT).or(BiomePredicate.temp(1.7f, Float.MAX_VALUE).and(BiomePredicate.rain(-3.4028235E38f, 0.2f)));
    public static final BiomePredicate GRASSLAND = BiomePredicate.type(Biome.Category.PLAINS);
    public static final BiomePredicate LAKE = BiomePredicate.type(Biome.Category.RIVER).and(BiomePredicate.name("lake")).or(BiomePredicate.name("lake"));
    public static final BiomePredicate MESA = BiomePredicate.type(Biome.Category.MESA);
    public static final BiomePredicate MOUNTAIN = BiomePredicate.type(Biome.Category.EXTREME_HILLS).or(BiomePredicate.name("mountain")).or(BiomePredicate.name("cliff"));
    public static final BiomePredicate VOLCANO = BiomePredicate.name("volcano").or(BiomePredicate.name("volcanic"));
    public static final BiomePredicate RIVER = BiomePredicate.type(Biome.Category.RIVER).not(LAKE);
    public static final BiomePredicate SAVANNA = BiomePredicate.type(Biome.Category.SAVANNA).or(BiomePredicate.temp(1.4f, Float.MAX_VALUE).and(BiomePredicate.rain(-3.4028235E38f, 0.4f)));
    public static final BiomePredicate STEPPE = BiomePredicate.name("steppe").and(BiomePredicate.temp(0.2f, Float.MAX_VALUE));
    public static final BiomePredicate TAIGA = BiomePredicate.type(Biome.Category.TAIGA).or(BiomePredicate.temp(-0.4f, 0.2f)).not(BiomePredicate.rainType(Biome.RainType.SNOW));
    public static final BiomePredicate TEMPERATE_FOREST = BiomePredicate.type(Biome.Category.FOREST).and(BiomePredicate.rain(-3.4028235E38f, 0.8f));
    public static final BiomePredicate TEMPERATE_RAINFOREST = BiomePredicate.type(Biome.Category.FOREST).and(BiomePredicate.rain(0.8f, Float.MAX_VALUE));
    public static final BiomePredicate TROPICAL_RAINFOREST = BiomePredicate.type(Biome.Category.JUNGLE);
    public static final BiomePredicate TUNDRA = BiomePredicate.type(Biome.Category.ICY).or(BiomePredicate.temp(-3.4028235E38f, -0.4f).and(BiomePredicate.rainType(Biome.RainType.SNOW)));
    public static final BiomePredicate WETLAND = BiomePredicate.type(Biome.Category.SWAMP);

    public boolean test(int var1, TFBiomeContext var2);

    default public BiomePredicate and(BiomePredicate other) {
        return (b, c) -> this.test(b, c) && other.test(b, c);
    }

    default public BiomePredicate not(BiomePredicate other) {
        return (b, c) -> this.test(b, c) && !other.test(b, c);
    }

    default public BiomePredicate or(BiomePredicate other) {
        return (b, c) -> this.test(b, c) || other.test(b, c);
    }

    public static BiomePredicate name(String ... name) {
        return (b, c) -> BiomePredicate.anyMatch(c.getName(b), name, String::contains);
    }

    public static BiomePredicate type(Biome.Category ... categories) {
        return (b, c) -> BiomePredicate.anyMatch(c.getProperties().getProperty(b, Biome::func_201856_r), categories, (x, y) -> x == y);
    }

    public static BiomePredicate rain(float min, float max) {
        return (b, c) -> BiomePredicate.testRange(c.getProperties().getMoisture(b), min, max);
    }

    public static BiomePredicate rainType(Biome.RainType ... rainTypes) {
        return (b, c) -> BiomePredicate.anyMatch(c.getProperties().getProperty(b, Biome::func_201851_b), rainTypes, (x, y) -> x == y);
    }

    public static BiomePredicate temp(float min, float max) {
        return (b, c) -> {
            float temp = c.getProperties().getTemperature(b);
            return BiomePredicate.testRange(temp, min, max);
        };
    }

    public static BiomePredicate depth(float min, float max) {
        return (b, c) -> BiomePredicate.testRange(c.getProperties().getDepth(b), min, max);
    }

    public static <T> boolean anyMatch(T value, T[] test, BiPredicate<T, T> tester) {
        for (T t : test) {
            if (!tester.test(value, t)) continue;
            return true;
        }
        return false;
    }

    public static boolean testRange(float value, float min, float max) {
        return value >= min && value <= max;
    }
}

