/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome;

import com.terraforged.mod.biome.BiomeBuilders;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.biome.utils.BiomeBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBiomes {
    private static final Map<RegistryKey<Biome>, RegistryKey<Biome>> remaps = new HashMap<RegistryKey<Biome>, RegistryKey<Biome>>();
    public static final RegistryKey<Biome> BRYCE = ModBiomes.createKey("bryce");
    public static final RegistryKey<Biome> COLD_STEPPE = ModBiomes.createKey("cold_steppe");
    public static final RegistryKey<Biome> COLD_MARSHLAND = ModBiomes.createKey("cold_marshland");
    public static final RegistryKey<Biome> FIR_FOREST = ModBiomes.createKey("fir_forest");
    public static final RegistryKey<Biome> FLOWER_PLAINS = ModBiomes.createKey("flower_plains");
    public static final RegistryKey<Biome> FROZEN_LAKE = ModBiomes.createKey("frozen_lake");
    public static final RegistryKey<Biome> FROZEN_MARSH = ModBiomes.createKey("frozen_marsh");
    public static final RegistryKey<Biome> LAKE = ModBiomes.createKey("lake");
    public static final RegistryKey<Biome> MARSHLAND = ModBiomes.createKey("marshland");
    public static final RegistryKey<Biome> SAVANNA_SCRUB = ModBiomes.createKey("savanna_scrub");
    public static final RegistryKey<Biome> SHATTERED_SAVANNA_SCRUB = ModBiomes.createKey("shattered_savanna_scrub");
    public static final RegistryKey<Biome> SNOWY_FIR_FOREST = ModBiomes.createKey("snowy_fir_forest");
    public static final RegistryKey<Biome> SNOWY_TAIGA_SCRUB = ModBiomes.createKey("snowy_taiga_scrub");
    public static final RegistryKey<Biome> STEPPE = ModBiomes.createKey("steppe");
    public static final RegistryKey<Biome> STONE_FOREST = ModBiomes.createKey("stone_forest");
    public static final RegistryKey<Biome> TAIGA_SCRUB = ModBiomes.createKey("taiga_scrub");
    public static final RegistryKey<Biome> WARM_BEACH = ModBiomes.createKey("warm_beach");

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Biome> event) {
        ModBiomes.register(event, BRYCE, BiomeBuilders.bryce());
        ModBiomes.register(event, COLD_STEPPE, BiomeBuilders.coldSteppe());
        ModBiomes.register(event, COLD_MARSHLAND, BiomeBuilders.coldMarsh());
        ModBiomes.register(event, FIR_FOREST, BiomeBuilders.firForest());
        ModBiomes.register(event, FLOWER_PLAINS, BiomeBuilders.flowerPlains());
        ModBiomes.register(event, FROZEN_LAKE, BiomeBuilders.frozenLake());
        ModBiomes.register(event, FROZEN_MARSH, BiomeBuilders.frozenMarsh());
        ModBiomes.register(event, LAKE, BiomeBuilders.lake());
        ModBiomes.register(event, MARSHLAND, BiomeBuilders.marshland());
        ModBiomes.register(event, SAVANNA_SCRUB, BiomeBuilders.savannaScrub());
        ModBiomes.register(event, SHATTERED_SAVANNA_SCRUB, BiomeBuilders.shatteredSavannaScrub());
        ModBiomes.register(event, SNOWY_FIR_FOREST, BiomeBuilders.snowyFirForest());
        ModBiomes.register(event, SNOWY_TAIGA_SCRUB, BiomeBuilders.snowyTaigaScrub());
        ModBiomes.register(event, STEPPE, BiomeBuilders.steppe());
        ModBiomes.register(event, STONE_FOREST, BiomeBuilders.stoneForest());
        ModBiomes.register(event, TAIGA_SCRUB, BiomeBuilders.taigaScrub());
        ModBiomes.register(event, WARM_BEACH, BiomeBuilders.warmBeach());
    }

    public static Biome remap(Biome biome, TFBiomeContext context) {
        Biome biomeOut;
        RegistryKey<Biome> keyOut;
        RegistryKey<Biome> keyIn = context.biomes.getKey(biome);
        if (keyIn != null && (keyOut = remaps.get(keyIn)) != null && (biomeOut = context.biomes.get(keyOut)) != null) {
            return biomeOut;
        }
        return biome;
    }

    private static RegistryKey<Biome> createKey(String name) {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("terraforged", name));
    }

    private static void register(RegistryEvent.Register<Biome> event, RegistryKey<Biome> key, BiomeBuilder builder) {
        event.getRegistry().register((IForgeRegistryEntry)builder.build(key));
        builder.registerTypes(key);
        builder.registerWeight(key);
        remaps.put(key, builder.getParentKey());
    }
}

