/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome;

import com.terraforged.mod.biome.utils.BiomeBuilder;
import com.terraforged.mod.biome.utils.BiomeUtils;
import com.terraforged.mod.featuremanager.matcher.dynamic.DynamicMatcher;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraftforge.common.BiomeManager;

public class BiomeBuilders {
    public static BiomeBuilder bryce() {
        BiomeBuilder builder = BiomeUtils.getBuilder((RegistryKey<Biome>)Biomes.field_150589_Z);
        builder.type(BiomeManager.BiomeType.DESERT);
        builder.filterFeatures(DynamicMatcher.config(BaseTreeFeatureConfig.class));
        DefaultBiomeFeatures.func_243705_S((BiomeGenerationSettings.Builder)builder.getSettings());
        return builder;
    }

    public static BiomeBuilder coldMarsh() {
        BiomeBuilder builder = BiomeUtils.getBuilder((RegistryKey<Biome>)Biomes.field_150584_S);
        builder.type(BiomeManager.BiomeType.ICY);
        builder.func_205417_d(0.5f);
        builder.func_205414_c(0.2f);
        builder.func_205419_a(Biome.Category.SWAMP);
        builder.func_205415_a(Biome.RainType.SNOW);
        builder.filterFeatures(DynamicMatcher.config(BaseTreeFeatureConfig.class));
        BiomeBuilders.deadBush(builder);
        BiomeBuilders.denseGrass(builder);
        BiomeBuilders.ferns(builder);
        return builder;
    }

    public static BiomeBuilder coldSteppe() {
        BiomeBuilder builder = BiomeUtils.getBuilder((RegistryKey<Biome>)Biomes.field_185432_ad);
        builder.type(BiomeManager.BiomeType.COOL);
        builder.func_205415_a(Biome.RainType.SNOW);
        builder.filterFeatures(DynamicMatcher.config(BaseTreeFeatureConfig.class), DynamicMatcher.feature(Feature.field_202283_ac), DynamicMatcher.of(Features.field_243826_aY), DynamicMatcher.of(Features.field_243825_aX));
        builder.func_205414_c(0.2f);
        builder.func_205417_d(0.025f);
        BiomeBuilders.deadBush(builder);
        BiomeBuilders.denseGrass(builder);
        BiomeBuilders.ferns(builder);
        return builder;
    }

    public static BiomeBuilder firForest() {
        BiomeBuilder builder = BiomeUtils.getBuilder((RegistryKey<Biome>)Biomes.field_76768_g);
        builder.type(BiomeManager.BiomeType.COOL);
        BiomeBuilders.deadBush(builder);
        BiomeBuilders.denseGrass(builder);
        BiomeBuilders.ferns(builder);
        return builder;
    }

    public static BiomeBuilder flowerPlains() {
        BiomeBuilder builder = BiomeUtils.getBuilder((RegistryKey<Biome>)Biomes.field_185444_T);
        builder.type(BiomeManager.BiomeType.COOL);
        return builder;
    }

    public static BiomeBuilder frozenLake() {
        BiomeBuilder builder = BiomeUtils.getBuilder((RegistryKey<Biome>)Biomes.field_76777_m);
        builder.type(BiomeManager.BiomeType.ICY);
        builder.filterFeatures(DynamicMatcher.config(BaseTreeFeatureConfig.class));
        return builder;
    }

    public static BiomeBuilder frozenMarsh() {
        BiomeBuilder builder = BiomeUtils.getBuilder((RegistryKey<Biome>)Biomes.field_150584_S);
        builder.type(BiomeManager.BiomeType.ICY);
        builder.func_205419_a(Biome.Category.SWAMP);
        builder.func_205417_d(0.15f);
        builder.func_205414_c(0.14999f);
        builder.func_205415_a(Biome.RainType.SNOW);
        builder.filterFeatures(DynamicMatcher.config(BaseTreeFeatureConfig.class));
        return builder;
    }

    public static BiomeBuilder lake() {
        BiomeBuilder builder = BiomeUtils.getBuilder((RegistryKey<Biome>)Biomes.field_76781_i);
        builder.type(BiomeManager.BiomeType.COOL);
        builder.filterFeatures(DynamicMatcher.config(BaseTreeFeatureConfig.class));
        return builder;
    }

    public static BiomeBuilder marshland() {
        BiomeBuilder builder = BiomeUtils.getBuilder((RegistryKey<Biome>)Biomes.field_76780_h);
        builder.type(BiomeManager.BiomeType.COOL);
        builder.func_205414_c(0.7f);
        builder.func_205419_a(Biome.Category.SWAMP);
        builder.filterFeatures(DynamicMatcher.config(BaseTreeFeatureConfig.class));
        BiomeBuilders.deadBush(builder);
        BiomeBuilders.ferns(builder);
        BiomeBuilders.denseGrass(builder);
        DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)builder.getSettings());
        return builder;
    }

    public static BiomeBuilder savannaScrub() {
        BiomeBuilder builder = BiomeUtils.getBuilder((RegistryKey<Biome>)Biomes.field_150588_X);
        builder.type(BiomeManager.BiomeType.WARM);
        builder.filterFeatures(DynamicMatcher.config(BaseTreeFeatureConfig.class));
        BiomeBuilders.deadBush(builder);
        BiomeBuilders.denseGrass(builder);
        return builder;
    }

    public static BiomeBuilder shatteredSavannaScrub() {
        BiomeBuilder builder = BiomeUtils.getBuilder((RegistryKey<Biome>)Biomes.field_185435_ag);
        builder.type(BiomeManager.BiomeType.WARM);
        BiomeBuilders.deadBush(builder);
        BiomeBuilders.denseGrass(builder);
        return builder;
    }

    public static BiomeBuilder snowyFirForest() {
        BiomeBuilder builder = BiomeUtils.getBuilder((RegistryKey<Biome>)Biomes.field_150584_S);
        builder.type(BiomeManager.BiomeType.ICY);
        builder.func_205419_a(Biome.Category.ICY);
        BiomeBuilders.ferns(builder);
        return builder;
    }

    public static BiomeBuilder snowyTaigaScrub() {
        BiomeBuilder builder = BiomeUtils.getBuilder((RegistryKey<Biome>)Biomes.field_150584_S);
        builder.type(BiomeManager.BiomeType.ICY);
        builder.filterFeatures(DynamicMatcher.config(BaseTreeFeatureConfig.class));
        BiomeBuilders.ferns(builder);
        return builder;
    }

    public static BiomeBuilder steppe() {
        BiomeBuilder builder = BiomeUtils.getBuilder((RegistryKey<Biome>)Biomes.field_185432_ad);
        builder.filterFeatures(DynamicMatcher.config(BaseTreeFeatureConfig.class), DynamicMatcher.feature(Feature.field_202283_ac), DynamicMatcher.of(Features.field_243826_aY), DynamicMatcher.of(Features.field_243825_aX));
        builder.setParentKey((RegistryKey<Biome>)Biomes.field_185436_ah);
        builder.func_205419_a(Biome.Category.SAVANNA);
        builder.copyAmbience((RegistryKey<Biome>)Biomes.field_150588_X);
        builder.func_205415_a(Biome.RainType.NONE);
        builder.func_205417_d(0.05f);
        builder.func_205414_c(1.2f);
        BiomeBuilders.deadBush(builder);
        BiomeBuilders.denseGrass(builder);
        return builder;
    }

    public static BiomeBuilder stoneForest() {
        BiomeBuilder builder = BiomeUtils.getBuilder((RegistryKey<Biome>)Biomes.field_76782_w);
        builder.type(BiomeManager.BiomeType.WARM);
        builder.weight(2);
        return builder;
    }

    public static BiomeBuilder taigaScrub() {
        BiomeBuilder builder = BiomeUtils.getBuilder((RegistryKey<Biome>)Biomes.field_76768_g);
        builder.type(BiomeManager.BiomeType.COOL);
        builder.filterFeatures(DynamicMatcher.config(BaseTreeFeatureConfig.class), DynamicMatcher.of(Features.field_243826_aY), DynamicMatcher.of(Features.field_243825_aX));
        BiomeBuilders.deadBush(builder);
        BiomeBuilders.denseGrass(builder);
        BiomeBuilders.ferns(builder);
        return builder;
    }

    public static BiomeBuilder warmBeach() {
        BiomeBuilder builder = BiomeUtils.getBuilder((RegistryKey<Biome>)Biomes.field_203614_T);
        builder.type(BiomeManager.BiomeType.WARM);
        builder.filterFeatures(DynamicMatcher.config(BaseTreeFeatureConfig.class));
        builder.func_205419_a(Biome.Category.BEACH);
        builder.func_205414_c(1.0f);
        return builder;
    }

    private static void deadBush(BiomeBuilder builder) {
        DefaultBiomeFeatures.func_243705_S((BiomeGenerationSettings.Builder)builder.getSettings());
    }

    private static void denseGrass(BiomeBuilder builder) {
        builder.getSettings().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243848_au);
        DefaultBiomeFeatures.func_243709_W((BiomeGenerationSettings.Builder)builder.getSettings());
        DefaultBiomeFeatures.func_243696_J((BiomeGenerationSettings.Builder)builder.getSettings());
    }

    private static void ferns(BiomeBuilder builder) {
        DefaultBiomeFeatures.func_243757_q((BiomeGenerationSettings.Builder)builder.getSettings());
    }
}

