/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.api.feature.decorator;

import com.terraforged.engine.world.heightmap.Levels;
import com.terraforged.mod.biome.TFBiomeContainer;
import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.chunk.fix.RegionDelegate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;

public class DecorationContext {
    private final IChunk chunk;
    private final Levels levels;
    private final WorldGenRegion region;
    private final TFBiomeContainer biomes;
    private final TFChunkGenerator generator;

    public DecorationContext(WorldGenRegion region, IChunk chunk, TFBiomeContainer biomes, TFChunkGenerator generator) {
        this.chunk = chunk;
        this.region = region;
        this.biomes = biomes;
        this.generator = generator;
        this.levels = generator.getContext().levels;
    }

    public IChunk getChunk() {
        return this.chunk;
    }

    public WorldGenRegion getRegion() {
        return this.region;
    }

    public TFBiomeContainer getBiomes() {
        return this.biomes;
    }

    public Biome getBiome(BlockPos pos) {
        return this.region.func_226691_t_(pos);
    }

    public Levels getLevels() {
        return this.levels;
    }

    public TFChunkGenerator getGenerator() {
        return this.generator;
    }

    public static DecorationContext of(ISeedReader world, ChunkGenerator generator) {
        if (generator instanceof TFChunkGenerator && world instanceof RegionDelegate) {
            TFChunkGenerator terraGenerator = (TFChunkGenerator)generator;
            WorldGenRegion region = ((RegionDelegate)world).getDelegate();
            IChunk chunk = region.func_212866_a_(region.func_201679_a(), region.func_201680_b());
            if (chunk.func_225549_i_() instanceof TFBiomeContainer) {
                TFBiomeContainer container = (TFBiomeContainer)chunk.func_225549_i_();
                return new DecorationContext(region, chunk, container, terraGenerator);
            }
        }
        return null;
    }
}

