/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import top.theillusivec4.polymorph.api.common.capability.ITileEntityRecipeData;

public class BlockEntityTicker {
    private static final Map<TileEntity, ITileEntityRecipeData> TICKABLE_BLOCKS = new HashMap<TileEntity, ITileEntityRecipeData>();

    public static void tick() {
        ArrayList<TileEntity> toRemove = new ArrayList<TileEntity>();
        for (Map.Entry<TileEntity, ITileEntityRecipeData> entry : TICKABLE_BLOCKS.entrySet()) {
            TileEntity be = entry.getKey();
            if (be.func_145837_r() || be.func_145831_w() != null && be.func_145831_w().func_201670_d()) {
                toRemove.add(be);
                continue;
            }
            entry.getValue().tick();
        }
        for (TileEntity be : toRemove) {
            TICKABLE_BLOCKS.remove(be);
        }
    }

    public static void add(ServerPlayerEntity serverPlayer, ITileEntityRecipeData recipeData) {
        ITileEntityRecipeData data = TICKABLE_BLOCKS.get(recipeData.getOwner());
        if (data != null) {
            data.addListener(serverPlayer);
        } else {
            recipeData.addListener(serverPlayer);
            TICKABLE_BLOCKS.put((TileEntity)recipeData.getOwner(), recipeData);
        }
    }

    public static void remove(ServerPlayerEntity serverPlayer) {
        ArrayList<TileEntity> toRemove = new ArrayList<TileEntity>();
        for (Map.Entry<TileEntity, ITileEntityRecipeData> entry : TICKABLE_BLOCKS.entrySet()) {
            entry.getValue().removeListener(serverPlayer);
            if (!entry.getValue().getListeners().isEmpty()) continue;
            toRemove.add(entry.getKey());
        }
        for (TileEntity blockEntity : toRemove) {
            TICKABLE_BLOCKS.remove(blockEntity);
        }
    }
}

