/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import top.theillusivec4.polymorph.common.network.client.CPacketBlockEntityListener;
import top.theillusivec4.polymorph.common.network.client.CPacketPersistentRecipeSelection;
import top.theillusivec4.polymorph.common.network.client.CPacketPlayerRecipeSelection;
import top.theillusivec4.polymorph.common.network.client.CPacketStackRecipeSelection;
import top.theillusivec4.polymorph.common.network.server.SPacketBlockEntityRecipeSync;
import top.theillusivec4.polymorph.common.network.server.SPacketHighlightRecipe;
import top.theillusivec4.polymorph.common.network.server.SPacketPlayerRecipeSync;
import top.theillusivec4.polymorph.common.network.server.SPacketRecipesList;

public class PolymorphNetwork {
    private static final String PTC_VERSION = "1";
    private static SimpleChannel instance;
    private static int id;

    public static SimpleChannel get() {
        return instance;
    }

    public static void setup() {
        instance = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("polymorph", "main")).networkProtocolVersion(() -> PTC_VERSION).clientAcceptedVersions(PTC_VERSION::equals).serverAcceptedVersions(PTC_VERSION::equals).simpleChannel();
        PolymorphNetwork.register(CPacketPlayerRecipeSelection.class, CPacketPlayerRecipeSelection::encode, CPacketPlayerRecipeSelection::decode, CPacketPlayerRecipeSelection::handle);
        PolymorphNetwork.register(CPacketPersistentRecipeSelection.class, CPacketPersistentRecipeSelection::encode, CPacketPersistentRecipeSelection::decode, CPacketPersistentRecipeSelection::handle);
        PolymorphNetwork.register(CPacketStackRecipeSelection.class, CPacketStackRecipeSelection::encode, CPacketStackRecipeSelection::decode, CPacketStackRecipeSelection::handle);
        PolymorphNetwork.register(CPacketBlockEntityListener.class, CPacketBlockEntityListener::encode, CPacketBlockEntityListener::decode, CPacketBlockEntityListener::handle);
        PolymorphNetwork.register(SPacketRecipesList.class, SPacketRecipesList::encode, SPacketRecipesList::decode, SPacketRecipesList::handle);
        PolymorphNetwork.register(SPacketHighlightRecipe.class, SPacketHighlightRecipe::encode, SPacketHighlightRecipe::decode, SPacketHighlightRecipe::handle);
        PolymorphNetwork.register(SPacketPlayerRecipeSync.class, SPacketPlayerRecipeSync::encode, SPacketPlayerRecipeSync::decode, SPacketPlayerRecipeSync::handle);
        PolymorphNetwork.register(SPacketBlockEntityRecipeSync.class, SPacketBlockEntityRecipeSync::encode, SPacketBlockEntityRecipeSync::decode, SPacketBlockEntityRecipeSync::handle);
    }

    public static <M> void register(Class<M> pClass, BiConsumer<M, PacketBuffer> pEncoder, Function<PacketBuffer, M> pDecoder, BiConsumer<M, Supplier<NetworkEvent.Context>> pMessage) {
        instance.registerMessage(id++, pClass, pEncoder, pDecoder, pMessage);
    }

    static {
        id = 0;
    }
}

