/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.integration;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import top.theillusivec4.polymorph.common.integration.AbstractCompatibilityModule;
import top.theillusivec4.polymorph.common.integration.appliedenergistics2.AppliedEnergisticsModule;
import top.theillusivec4.polymorph.common.integration.craftingstation.CraftingStationModule;
import top.theillusivec4.polymorph.common.integration.cyclic.CyclicModule;
import top.theillusivec4.polymorph.common.integration.extendedcrafting.ExtendedCraftingModule;
import top.theillusivec4.polymorph.common.integration.fastbench.FastBenchModule;
import top.theillusivec4.polymorph.common.integration.fastbenchminusreplacement.FastBenchMinusModule;
import top.theillusivec4.polymorph.common.integration.fastfurnace.FastFurnaceModule;
import top.theillusivec4.polymorph.common.integration.fastfurnaceminusreplacement.FastFurnaceMinusModule;
import top.theillusivec4.polymorph.common.integration.ironfurnaces.IronFurnacesModule;
import top.theillusivec4.polymorph.common.integration.occultism.OccultismModule;
import top.theillusivec4.polymorph.common.integration.prettypipes.PrettyPipesModule;
import top.theillusivec4.polymorph.common.integration.refinedstorage.RefinedStorageModule;
import top.theillusivec4.polymorph.common.integration.refinedstorageaddons.RefinedStorageAddonsModule;
import top.theillusivec4.polymorph.common.integration.sophisticatedbackpacks.SophisticatedBackpacksModule;
import top.theillusivec4.polymorph.common.integration.tconstruct.TinkersConstructModule;
import top.theillusivec4.polymorph.common.integration.toms_storage.TomsStorageModule;

public class PolymorphIntegrations {
    private static final Set<String> CONFIG_ACTIVATED = new HashSet<String>();
    private static final Map<String, Supplier<Supplier<AbstractCompatibilityModule>>> INTEGRATIONS = new HashMap<String, Supplier<Supplier<AbstractCompatibilityModule>>>();
    private static final Set<AbstractCompatibilityModule> ACTIVE_INTEGRATIONS = new HashSet<AbstractCompatibilityModule>();

    public static void loadConfig() {
        ConfigSpec spec = new ConfigSpec();
        for (Mod mod : Mod.values()) {
            spec.define(mod.getId(), (Object)true);
        }
        FileConfig config = FileConfig.of((Path)FMLPaths.CONFIGDIR.get().resolve("polymorph-integrations.toml"));
        config.load();
        if (!spec.isCorrect((Config)config)) {
            spec.correct((Config)config);
        }
        for (Mod mod : Mod.values()) {
            if (!((Boolean)config.get(mod.getId())).booleanValue()) continue;
            CONFIG_ACTIVATED.add(mod.getId());
        }
        config.save();
        config.close();
    }

    public static void init() {
        ModList modList = ModList.get();
        INTEGRATIONS.forEach((modid, supplier) -> {
            if (CONFIG_ACTIVATED.contains(modid) && modList.isLoaded(modid)) {
                ACTIVE_INTEGRATIONS.add((AbstractCompatibilityModule)((Supplier)supplier.get()).get());
            }
        });
    }

    public static void setup() {
        for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
            integration.setup();
        }
    }

    public static void clientSetup() {
        for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
            integration.clientSetup();
        }
    }

    public static Set<AbstractCompatibilityModule> get() {
        return ImmutableSet.copyOf(ACTIVE_INTEGRATIONS);
    }

    public static Set<String> getConfigActivated() {
        return ImmutableSet.copyOf(CONFIG_ACTIVATED);
    }

    static {
        INTEGRATIONS.put(Mod.PRETTY_PIPES.getId(), () -> PrettyPipesModule::new);
        INTEGRATIONS.put(Mod.REFINED_STORAGE.getId(), () -> RefinedStorageModule::new);
        INTEGRATIONS.put(Mod.REFINED_STORAGE_ADDONS.getId(), () -> RefinedStorageAddonsModule::new);
        INTEGRATIONS.put(Mod.TINKERS_CONSTRUCT.getId(), () -> TinkersConstructModule::new);
        INTEGRATIONS.put(Mod.FASTWORKBENCH.getId(), () -> FastBenchModule::new);
        INTEGRATIONS.put(Mod.CRAFTING_STATION.getId(), () -> CraftingStationModule::new);
        INTEGRATIONS.put(Mod.FASTFURNACE.getId(), () -> FastFurnaceModule::new);
        INTEGRATIONS.put(Mod.CYCLIC.getId(), () -> CyclicModule::new);
        INTEGRATIONS.put(Mod.TOMS_STORAGE.getId(), () -> TomsStorageModule::new);
        INTEGRATIONS.put(Mod.SOPHISTICATED_BACKPACKS.getId(), () -> SophisticatedBackpacksModule::new);
        INTEGRATIONS.put(Mod.APPLIED_ENERGISTICS_2.getId(), () -> AppliedEnergisticsModule::new);
        INTEGRATIONS.put(Mod.IRON_FURNACES.getId(), () -> IronFurnacesModule::new);
        INTEGRATIONS.put(Mod.FASTFURNACE_MINUS_REPLACEMENT.getId(), () -> FastFurnaceMinusModule::new);
        INTEGRATIONS.put(Mod.FASTWORKBENCH_MINUS_REPLACEMENT.getId(), () -> FastBenchMinusModule::new);
        INTEGRATIONS.put(Mod.OCCULTISM.getId(), () -> OccultismModule::new);
        INTEGRATIONS.put(Mod.EXTENDED_CRAFTING.getId(), () -> ExtendedCraftingModule::new);
    }

    public static enum Mod {
        JEI("jei"),
        CRAFTINGCRAFT("craftingcraft"),
        CRAFTING_STATION("craftingstation"),
        PRETTY_PIPES("prettypipes"),
        TOMS_STORAGE("toms_storage"),
        FASTWORKBENCH("fastbench"),
        SIMPLE_STORAGE_NETWORK("storagenetwork"),
        REFINED_STORAGE("refinedstorage"),
        REFINED_STORAGE_ADDONS("refinedstorageaddons"),
        TINKERS_CONSTRUCT("tconstruct"),
        CYCLIC("cyclic"),
        SOPHISTICATED_BACKPACKS("sophisticatedbackpacks"),
        APPLIED_ENERGISTICS_2("appliedenergistics2"),
        IRON_FURNACES("ironfurnaces"),
        FASTFURNACE("fastfurnace"),
        FASTSUITE("fastsuite"),
        FASTWORKBENCH_MINUS_REPLACEMENT("fastbenchminusreplacement"),
        FASTFURNACE_MINUS_REPLACEMENT("fastfurnaceminusreplacement"),
        EXTENDED_CRAFTING("extendedcrafting"),
        OCCULTISM("occultism");

        private final String id;

        private Mod(String pId) {
            this.id = pId;
        }

        public String getId() {
            return this.id;
        }
    }
}

