/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.imc.WorldTransmutationEntry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraftforge.fml.InterModComms;

public final class WorldTransmutations {
    private static List<WorldTransmutationEntry> DEFAULT_ENTRIES = Collections.emptyList();
    private static List<WorldTransmutationEntry> ENTRIES = Collections.emptyList();

    public static void init() {
        WorldTransmutations.registerDefault(Blocks.field_150348_b, Blocks.field_150347_e, Blocks.field_196658_i);
        WorldTransmutations.registerDefault(Blocks.field_150347_e, Blocks.field_150348_b, Blocks.field_196658_i);
        WorldTransmutations.registerDefault(Blocks.field_196658_i, Blocks.field_150354_m, Blocks.field_150347_e);
        WorldTransmutations.registerDefault(Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150347_e);
        WorldTransmutations.registerDefault(Blocks.field_150354_m, Blocks.field_196658_i, Blocks.field_150347_e);
        WorldTransmutations.registerBackAndForth(Blocks.field_150351_n, Blocks.field_150322_A);
        WorldTransmutations.registerBackAndForth(Blocks.field_150355_j, Blocks.field_150432_aD);
        WorldTransmutations.registerBackAndForth(Blocks.field_150353_l, Blocks.field_150343_Z);
        WorldTransmutations.registerBackAndForth(Blocks.field_150440_ba, Blocks.field_150423_aK);
        WorldTransmutations.registerDefault(Blocks.field_196650_c, Blocks.field_196654_e, Blocks.field_196656_g);
        WorldTransmutations.registerDefault(Blocks.field_196654_e, Blocks.field_196656_g, Blocks.field_196650_c);
        WorldTransmutations.registerDefault(Blocks.field_196656_g, Blocks.field_196650_c, Blocks.field_196654_e);
        WorldTransmutations.registerConsecutivePairsAllStates(Blocks.field_196617_K, Blocks.field_196619_M, Blocks.field_196618_L, Blocks.field_196620_N, Blocks.field_196621_O, Blocks.field_196623_P);
        WorldTransmutations.registerConsecutivePairsAllStates(Blocks.field_203204_R, Blocks.field_203206_T, Blocks.field_203205_S, Blocks.field_203207_U, Blocks.field_203208_V, Blocks.field_203209_W);
        WorldTransmutations.registerConsecutivePairs(Blocks.field_196626_Q, Blocks.field_196631_S, Blocks.field_196629_R, Blocks.field_196634_T, Blocks.field_196637_U, Blocks.field_196639_V);
        WorldTransmutations.registerConsecutivePairs(Blocks.field_209389_ab, Blocks.field_209391_ad, Blocks.field_209390_ac, Blocks.field_209392_ae, Blocks.field_209393_af, Blocks.field_209394_ag);
        WorldTransmutations.registerConsecutivePairs(Blocks.field_196642_W, Blocks.field_196647_Y, Blocks.field_196645_X, Blocks.field_196648_Z, Blocks.field_196572_aa, Blocks.field_196574_ab);
        WorldTransmutations.registerConsecutivePairs(Blocks.field_196674_t, Blocks.field_196676_v, Blocks.field_196675_u, Blocks.field_196678_w, Blocks.field_196679_x, Blocks.field_196680_y);
        WorldTransmutations.registerConsecutivePairs(Blocks.field_196662_n, Blocks.field_196666_p, Blocks.field_196664_o, Blocks.field_196668_q, Blocks.field_196670_r, Blocks.field_196672_s);
        WorldTransmutations.registerConsecutivePairsAllStates(Blocks.field_196622_bq, Blocks.field_196627_bs, Blocks.field_196624_br, Blocks.field_196630_bt, Blocks.field_196632_bu, Blocks.field_196635_bv);
        WorldTransmutations.registerConsecutivePairsAllStates(Blocks.field_150476_ad, Blocks.field_150487_bG, Blocks.field_150485_bF, Blocks.field_150481_bH, Blocks.field_150400_ck, Blocks.field_150401_cl);
        WorldTransmutations.registerConsecutivePairsAllStates(Blocks.field_180407_aO, Blocks.field_180404_aQ, Blocks.field_180408_aP, Blocks.field_180403_aR, Blocks.field_180405_aT, Blocks.field_180406_aS);
        WorldTransmutations.registerConsecutivePairs(Blocks.field_196663_cq, Blocks.field_196667_cs, Blocks.field_196665_cr, Blocks.field_196669_ct, Blocks.field_196671_cu, Blocks.field_196673_cv);
        WorldTransmutations.registerConsecutivePairs(Blocks.field_196828_iC, Blocks.field_196830_iD, Blocks.field_196832_iE, Blocks.field_196834_iF, Blocks.field_196836_iG, Blocks.field_196838_iH, Blocks.field_196840_iI, Blocks.field_196842_iJ, Blocks.field_196844_iK, Blocks.field_196846_iL, Blocks.field_196848_iM, Blocks.field_196850_iN, Blocks.field_196852_iO, Blocks.field_196854_iP, Blocks.field_196856_iQ, Blocks.field_196858_iR);
        WorldTransmutations.registerConsecutivePairs(Blocks.field_196860_iS, Blocks.field_196862_iT, Blocks.field_196864_iU, Blocks.field_196866_iV, Blocks.field_196868_iW, Blocks.field_196870_iX, Blocks.field_196872_iY, Blocks.field_196874_iZ, Blocks.field_196877_ja, Blocks.field_196878_jb, Blocks.field_196879_jc, Blocks.field_196880_jd, Blocks.field_196881_je, Blocks.field_196882_jf, Blocks.field_196883_jg, Blocks.field_196884_jh);
        WorldTransmutations.registerConsecutivePairs(Blocks.field_196724_fH, Blocks.field_196725_fI, Blocks.field_196727_fJ, Blocks.field_196729_fK, Blocks.field_196731_fL, Blocks.field_196733_fM, Blocks.field_196735_fN, Blocks.field_196737_fO, Blocks.field_196739_fP, Blocks.field_196741_fQ, Blocks.field_196743_fR, Blocks.field_196745_fS, Blocks.field_196747_fT, Blocks.field_196749_fU, Blocks.field_196751_fV, Blocks.field_196753_fW);
        WorldTransmutations.registerConsecutivePairs(Blocks.field_196556_aL, Blocks.field_196557_aM, Blocks.field_196558_aN, Blocks.field_196559_aO, Blocks.field_196560_aP, Blocks.field_196561_aQ, Blocks.field_196562_aR, Blocks.field_196563_aS, Blocks.field_196564_aT, Blocks.field_196565_aU, Blocks.field_196566_aV, Blocks.field_196567_aW, Blocks.field_196568_aX, Blocks.field_196569_aY, Blocks.field_196570_aZ, Blocks.field_196602_ba);
        WorldTransmutations.registerConsecutivePairs(Blocks.field_196777_fo, Blocks.field_196778_fp, Blocks.field_196780_fq, Blocks.field_196782_fr, Blocks.field_196783_fs, Blocks.field_196785_ft, Blocks.field_196787_fu, Blocks.field_196789_fv, Blocks.field_196791_fw, Blocks.field_196793_fx, Blocks.field_196795_fy, Blocks.field_196797_fz, Blocks.field_196719_fA, Blocks.field_196720_fB, Blocks.field_196721_fC, Blocks.field_196722_fD);
        WorldTransmutations.registerConsecutivePairs(Blocks.field_196807_gj, Blocks.field_196808_gk, Blocks.field_196809_gl, Blocks.field_196810_gm, Blocks.field_196811_gn, Blocks.field_196812_go, Blocks.field_196813_gp, Blocks.field_196815_gq, Blocks.field_196816_gr, Blocks.field_196818_gs, Blocks.field_196819_gt, Blocks.field_196820_gu, Blocks.field_196821_gv, Blocks.field_196822_gw, Blocks.field_196823_gx, Blocks.field_196824_gy);
        WorldTransmutations.registerConsecutivePairsAllStates(Blocks.field_196825_gz, Blocks.field_196758_gA, Blocks.field_196759_gB, Blocks.field_196760_gC, Blocks.field_196761_gD, Blocks.field_196763_gE, Blocks.field_196764_gF, Blocks.field_196765_gG, Blocks.field_196767_gH, Blocks.field_196768_gI, Blocks.field_196769_gJ, Blocks.field_196771_gK, Blocks.field_196773_gL, Blocks.field_196774_gM, Blocks.field_196775_gN, Blocks.field_196776_gO);
        WorldTransmutations.registerBackAndForth(Blocks.field_150425_aM, Blocks.field_235336_cN_);
        WorldTransmutations.registerDefault(Blocks.field_150424_aL, Blocks.field_235381_mu_, Blocks.field_235372_ml_);
        WorldTransmutations.registerDefault(Blocks.field_235381_mu_, Blocks.field_235372_ml_, Blocks.field_150424_aL);
        WorldTransmutations.registerDefault(Blocks.field_235372_ml_, Blocks.field_235381_mu_, Blocks.field_150424_aL);
        WorldTransmutations.registerBackAndForthAllStates(Blocks.field_235377_mq_, Blocks.field_235368_mh_);
        WorldTransmutations.registerBackAndForthAllStates(Blocks.field_235378_mr_, Blocks.field_235369_mi_);
        WorldTransmutations.registerBackAndForth(Blocks.field_235379_ms_, Blocks.field_235370_mj_);
        WorldTransmutations.registerBackAndForth(Blocks.field_235380_mt_, Blocks.field_235371_mk_);
        WorldTransmutations.registerBackAndForth(Blocks.field_189878_dg, Blocks.field_235374_mn_);
        WorldTransmutations.registerBackAndForth(Blocks.field_235382_mv_, Blocks.field_235373_mm_);
        WorldTransmutations.registerBackAndForth(Blocks.field_235343_mB_, Blocks.field_235375_mo_);
        WorldTransmutations.registerBackAndForth(Blocks.field_235344_mC_, Blocks.field_235345_mD_);
        WorldTransmutations.registerBackAndForthAllStates(Blocks.field_235346_mE_, Blocks.field_235347_mF_);
        WorldTransmutations.registerBackAndForthAllStates(Blocks.field_235356_mO_, Blocks.field_235357_mP_);
        WorldTransmutations.registerBackAndForthAllStates(Blocks.field_235350_mI_, Blocks.field_235351_mJ_);
        WorldTransmutations.registerBackAndForthAllStates(Blocks.field_235348_mG_, Blocks.field_235349_mH_);
    }

    @Nullable
    public static BlockState getWorldTransmutation(BlockState current, boolean isSneaking) {
        for (WorldTransmutationEntry e : ENTRIES) {
            if (e.getOrigin() != current) continue;
            return isSneaking ? e.getAltResult() : e.getResult();
        }
        return null;
    }

    public static List<WorldTransmutationEntry> getWorldTransmutations() {
        return ENTRIES;
    }

    public static void setWorldTransmutation(List<WorldTransmutationEntry> entries) {
        DEFAULT_ENTRIES = ImmutableList.copyOf(entries);
        WorldTransmutations.resetWorldTransmutations();
    }

    public static void resetWorldTransmutations() {
        ENTRIES = new ArrayList<WorldTransmutationEntry>(DEFAULT_ENTRIES);
    }

    public static void register(BlockState from, BlockState result, @Nullable BlockState altResult) {
        ENTRIES.add(new WorldTransmutationEntry(from, result, altResult));
    }

    private static void registerIMC(BlockState from, BlockState result, @Nullable BlockState altResult) {
        InterModComms.sendTo((String)"projecte", (String)"register_world_transmutation", () -> new WorldTransmutationEntry(from, result, altResult));
    }

    private static void registerDefault(Block from, Block result, @Nullable Block altResult) {
        WorldTransmutations.registerIMC(from.func_176223_P(), result.func_176223_P(), altResult == null ? null : altResult.func_176223_P());
    }

    private static void registerAllStates(Block from, Block result, @Nullable Block altResult) {
        StateContainer stateContainer = from.func_176194_O();
        ImmutableList validStates = stateContainer.func_177619_a();
        for (BlockState validState : validStates) {
            try {
                BlockState resultState = WorldTransmutations.copyProperties(validState, result.func_176223_P());
                BlockState altResultState = altResult == null ? null : WorldTransmutations.copyProperties(validState, altResult.func_176223_P());
                WorldTransmutations.registerIMC(validState, resultState, altResultState);
            }
            catch (IllegalArgumentException e) {
                PECore.LOGGER.error("Something went wrong registering conversions for " + from.getRegistryName(), (Throwable)e);
            }
        }
    }

    private static BlockState copyProperties(BlockState source, BlockState target) {
        ImmutableMap values = source.func_206871_b();
        for (Map.Entry entry : values.entrySet()) {
            target = WorldTransmutations.applyProperty(target, (Property)entry.getKey(), (Comparable)entry.getValue());
        }
        return target;
    }

    private static <T extends Comparable<T>, V extends T> BlockState applyProperty(BlockState target, Property<T> property, Comparable<?> value) {
        return (BlockState)target.func_206870_a(property, value);
    }

    private static void registerBackAndForth(Block first, Block second) {
        WorldTransmutations.registerDefault(first, second, null);
        WorldTransmutations.registerDefault(second, first, null);
    }

    private static void registerBackAndForthAllStates(Block first, Block second) {
        WorldTransmutations.registerAllStates(first, second, null);
        WorldTransmutations.registerAllStates(second, first, null);
    }

    private static void registerConsecutivePairs(RegisterBlock registerMethod, Block ... blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            Block prev = i == 0 ? blocks[blocks.length - 1] : blocks[i - 1];
            Block cur = blocks[i];
            Block next = i == blocks.length - 1 ? blocks[0] : blocks[i + 1];
            registerMethod.register(cur, next, prev);
        }
    }

    private static void registerConsecutivePairs(Block ... blocks) {
        WorldTransmutations.registerConsecutivePairs(WorldTransmutations::registerDefault, blocks);
    }

    private static void registerConsecutivePairsAllStates(Block ... blocks) {
        WorldTransmutations.registerConsecutivePairs(WorldTransmutations::registerAllStates, blocks);
    }

    @FunctionalInterface
    private static interface RegisterBlock {
        public void register(Block var1, Block var2, @Nullable Block var3);
    }
}

