/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl;

import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.proxy.ITransmutationProxy;
import moze_intel.projecte.impl.TransmutationOffline;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class TransmutationProxyImpl
implements ITransmutationProxy {
    public static final TransmutationProxyImpl instance = new TransmutationProxyImpl();

    private TransmutationProxyImpl() {
    }

    @Override
    @Nonnull
    public IKnowledgeProvider getKnowledgeProviderFor(@Nonnull UUID playerUUID) {
        if (Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER) {
            return (IKnowledgeProvider)DistExecutor.unsafeRunForDist(() -> () -> {
                Preconditions.checkState((Minecraft.func_71410_x().field_71439_g != null ? 1 : 0) != 0, (Object)"Client player doesn't exist!");
                return (IKnowledgeProvider)Minecraft.func_71410_x().field_71439_g.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY).orElseThrow(NullPointerException::new);
            }, () -> () -> {
                throw new RuntimeException("unreachable");
            });
        }
        Preconditions.checkNotNull((Object)playerUUID);
        Preconditions.checkNotNull((Object)ServerLifecycleHooks.getCurrentServer(), (Object)"Server must be running to query knowledge!");
        PlayerEntity player = this.findOnlinePlayer(playerUUID);
        if (player != null) {
            return (IKnowledgeProvider)player.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY).orElseThrow(NullPointerException::new);
        }
        return TransmutationOffline.forPlayer(playerUUID);
    }

    private PlayerEntity findOnlinePlayer(UUID playerUUID) {
        for (PlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            if (!player.func_110124_au().equals(playerUUID)) continue;
            return player;
        }
        return null;
    }
}

