/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import mcjty.lib.client.GuiTools;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.icons.IconManager;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;

public class WindowManager {
    private IconManager iconManager = new IconManager(this);
    private final Screen gui;
    private List<Window> windows = new ArrayList<Window>();
    private List<Window> modalWindows = new ArrayList<Window>();
    private int mouseWheel = -1;

    public WindowManager(Screen gui) {
        this.gui = gui;
    }

    public Screen getGui() {
        return this.gui;
    }

    public IconManager getIconManager() {
        return this.iconManager;
    }

    public void clearFocus() {
        Stream.concat(this.windows.stream(), this.modalWindows.stream()).forEach(w -> w.setFocus(null));
    }

    public void setFocus(Widget<?> w) {
        this.clearFocus();
        Stream.concat(this.windows.stream(), this.modalWindows.stream()).filter(window -> window.isWidgetOnWindow(w)).findFirst().ifPresent(window -> window.setTextFocus(w));
    }

    public Widget<?> getTextFocus() {
        return this.getInteractableWindows().map(Window::getTextFocus).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public WindowManager addWindow(Window w) {
        this.windows.add(w);
        w.setWindowManager(this);
        return this;
    }

    public WindowManager addModalWindow(Window w) {
        this.modalWindows.add(w);
        w.setWindowManager(this);
        return this;
    }

    public Window createModalWindow(AbstractContainerWidget<?> topLevel) {
        Window w = new Window(this.gui, topLevel);
        this.addModalWindow(w);
        return w;
    }

    public void closeWindow(Window window) {
        if (this.windows.contains(window)) {
            this.windows.remove(window);
        } else if (this.modalWindows.contains(window)) {
            this.modalWindows.remove(window);
        }
    }

    public int getMouseWheel() {
        return this.mouseWheel;
    }

    public <T extends GenericTileEntity> void syncBindings(T te) {
        this.windows.stream().forEach(window -> window.syncBindings(te));
        this.modalWindows.stream().forEach(window -> window.syncBindings(te));
    }

    public void draw(MatrixStack matrixStack) {
        this.mouseWheel = 0;
        this.windows.stream().forEach(window -> window.draw(matrixStack));
        this.modalWindows.stream().forEach(window -> window.draw(matrixStack));
        this.iconManager.draw(this.gui, matrixStack);
    }

    private Stream<Window> getInteractableWindows() {
        if (this.modalWindows.isEmpty()) {
            return this.windows.stream();
        }
        Window window = this.modalWindows.get(this.modalWindows.size() - 1);
        return Stream.builder().add(window).build();
    }

    public List<Window> getWindows() {
        return this.windows;
    }

    public Stream<Window> getModalWindows() {
        return this.modalWindows.stream();
    }

    public void drawTooltips(MatrixStack matrixStack) {
        int x = GuiTools.getRelativeX(this.gui);
        int y = GuiTools.getRelativeY(this.gui);
        this.getInteractableWindows().forEach(w -> {
            List<String> tooltips = w.getTooltips();
            if (tooltips != null) {
                GenericGuiContainer gui = (GenericGuiContainer)this.gui;
                gui.drawHoveringText(matrixStack, tooltips, w.getTooltipItems(), x - gui.getGuiLeft(), y - gui.getGuiTop(), gui.getMinecraft().field_71466_p);
            }
        });
        RenderHelper.func_227783_c_();
    }

    public Optional<Widget<?>> findWidgetAtPosition(double x, double y) {
        Stream<Widget> s = this.windows.stream().map(w -> w.getWidgetAtPosition(x, y));
        return s.filter(Objects::nonNull).findFirst();
    }

    public void mouseClicked(double x, double y, int button) {
        if (!this.iconManager.isClickHoldToDrag() && this.iconManager.isDragging()) {
            if (button == 1) {
                this.iconManager.cancelDragging();
            } else {
                this.iconManager.stopDragging(x, y);
            }
            return;
        }
        this.getInteractableWindows().forEach(w -> w.mouseClicked(x, y, button));
    }

    public void mouseDragged(double x, double y, int button) {
        this.getInteractableWindows().forEach(w -> w.mouseDragged(x, y, button));
    }

    public void mouseScrolled(double x, double y, double amount) {
        this.getInteractableWindows().forEach(w -> w.mouseScrolled(x, y, amount));
    }

    public void mouseReleased(double x, double y, int state) {
        if (this.iconManager.isClickHoldToDrag() && this.iconManager.isDragging()) {
            this.iconManager.stopDragging(x, y);
        }
        this.getInteractableWindows().forEach(w -> w.mouseReleased(x, y, state));
    }

    public boolean keyTyped(int keyCode, int scanCode) {
        return this.getInteractableWindows().allMatch(w -> !w.keyTyped(keyCode, scanCode));
    }

    public boolean charTyped(char codePoint) {
        return this.getInteractableWindows().allMatch(w -> !w.charTyped(codePoint));
    }
}

