/*
 * Decompiled with CFR 0.152.
 */
package ca.glasspelican.loginshield.configuration;

import net.minecraftforge.common.ForgeConfigSpec;

public class General {
    private static ForgeConfigSpec.IntValue protectTime;
    private static ForgeConfigSpec.IntValue dimensionTime;
    private static ForgeConfigSpec.BooleanValue enableVoidRescue;
    private static ForgeConfigSpec.BooleanValue blockConflict;
    private static ForgeConfigSpec.BooleanValue mobProtection;
    private static ForgeConfigSpec.BooleanValue squidControl;
    private static ForgeConfigSpec.BooleanValue enableVoidMessage;

    public General(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        protectTime = builder.comment("Sets the Max time a player will be protected in seconds").defineInRange("spawnProtectTime", 20, 0, Integer.MAX_VALUE);
        dimensionTime = builder.comment("Sets the Max time a player will be protected on dimension change in seconds").defineInRange("dimensionChangeTime", 15, 0, Integer.MAX_VALUE);
        blockConflict = builder.comment("Detects if a player is in a conflicting block and moves the player to a nearby emptyspace").define("enableSpawnConflictDetection", true);
        enableVoidRescue = builder.comment("Teleport the player to world spawn if they fall out of the world during protect time").define("enableVoidRescue", true);
        mobProtection = builder.comment("Makes the player invisible to mobs while protected").define("enableMobProtection", true);
        squidControl = builder.comment("Prevents spawning of squid in non water blocks and vary small pools. Intended for use in skyblocks.").define("enableSquidControl", false);
        enableVoidMessage = builder.comment("Enables the void Rescue chat message").define("enableVoidMessage", false);
        builder.pop();
    }

    static boolean isSquidControl() {
        return (Boolean)squidControl.get();
    }

    static boolean isMobProtection() {
        return (Boolean)mobProtection.get();
    }

    static int getProtectTime() {
        return (Integer)protectTime.get();
    }

    static int getDimensionTime() {
        return (Integer)dimensionTime.get();
    }

    static boolean getEnableVoidRescue() {
        return (Boolean)enableVoidRescue.get();
    }

    static boolean isBlockConflict() {
        return (Boolean)blockConflict.get();
    }

    static String getVoidRescueMessage() {
        if (Boolean.TRUE.equals(enableVoidMessage.get())) {
            return "A pelican snatched you from the void";
        }
        return "";
    }
}

