/*
 * Decompiled with CFR 0.152.
 */
package ca.glasspelican.loginshield;

import ca.glasspelican.loginshield.PlayerManager;
import ca.glasspelican.loginshield.configuration.ConfigurationManager;
import ca.glasspelican.loginshield.status;
import ca.glasspelican.loginshield.util.LogHelper;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="login_shield")
public class LoginShield {
    public static final String MODID = "login_shield";
    public static final String VERSION = "@VERSION@";
    public static final String CHARSET = "UTF-8";

    public LoginShield() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ConfigurationManager.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ConfigurationManager.configSpec);
    }

    private void setup(FMLCommonSetupEvent event) {
        LogHelper.info("Raising Shields: version @VERSION@");
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        status thisPlayer = PlayerManager.add(event.getPlayer());
        World entityWorld = thisPlayer.getPlayerEntity().func_130014_f_();
        LogHelper.debug("Protecting: " + thisPlayer.getPlayerEntity().func_145748_c_());
        if (!entityWorld.func_175623_d(thisPlayer.getStartBlockPos()) || !entityWorld.func_175623_d(thisPlayer.getAboveStartBlockPos())) {
            LogHelper.debug("Block conflicting with player");
            if (ConfigurationManager.isBlockConflict()) {
                PlayerManager.teleportPlayer(thisPlayer);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerManager.remove(event.getPlayer().func_145782_y());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (!ConfigurationManager.isVoidTeleport()) {
            return;
        }
        List<Integer> list = PlayerManager.getProtectedPlayerCache();
        synchronized (list) {
            for (Integer entityID : PlayerManager.getProtectedPlayerCache()) {
                status thisPlayer = PlayerManager.get(entityID);
                if (thisPlayer == null) {
                    LogHelper.error("If you see this tell Glasspelican that the Player Manager returned a NULL player");
                    PlayerManager.remove(entityID);
                    continue;
                }
                if (!thisPlayer.getHasInteracted().booleanValue()) {
                    if (thisPlayer.getStartX().intValue() != thisPlayer.getCurrentPos().func_177958_n() || thisPlayer.getStartZ().intValue() != thisPlayer.getCurrentPos().func_177952_p()) {
                        // empty if block
                    }
                    if (!thisPlayer.isTimeProtected() || thisPlayer.getCurrentPos().func_177956_o() >= 0) continue;
                    PlayerManager.teleportPlayerSpawn(thisPlayer);
                    PlayerManager.sendChatMessage(thisPlayer, ConfigurationManager.getVoidRescueMessage());
                    continue;
                }
                PlayerManager.remove(entityID);
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingHurtEvent event) {
        Integer entityID;
        if (event.getEntityLiving() instanceof PlayerEntity && PlayerManager.isProtected(entityID = Integer.valueOf(event.getEntityLiving().func_145782_y()))) {
            LogHelper.debug("Blocking Damage");
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingSpawn(LivingSpawnEvent event) {
        if (ConfigurationManager.isSquidControl() && event.getEntityLiving() instanceof SquidEntity) {
            BlockPos blockPos = event.getEntity().func_233580_cy_();
            if (event.getWorld().func_180495_p(blockPos).func_185904_a() == Material.field_151586_h) {
                event.getEntity().func_174812_G();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            status player = PlayerManager.get(event.getEntityLiving().func_145782_y());
            if (player == null) {
                return;
            }
            player.setHasInteracted(true);
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            status player = PlayerManager.get(event.getEntityLiving().func_145782_y());
            if (player == null) {
                return;
            }
            player.setHasInteracted(true);
        }
    }

    @SubscribeEvent
    public void onPlayerItemDrop(ItemTossEvent event) {
        status player = PlayerManager.get(event.getPlayer());
        if (player == null) {
            return;
        }
        player.setHasInteracted(true);
    }

    @SubscribeEvent
    public void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        status player = PlayerManager.get(event.getPlayer());
        if (player == null) {
            return;
        }
        int dimensionTime = ConfigurationManager.getDimensionTime();
        if (dimensionTime >= 0) {
            player.setHasInteracted(true);
            player.setTimeProtected(dimensionTime);
            PlayerManager.add(event.getPlayer());
            player.setStartBlockPos(event.getPlayer().func_233580_cy_());
        }
    }

    @SubscribeEvent
    public void onAiTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof PlayerEntity && ConfigurationManager.isMobProtection() && PlayerManager.isProtected(event.getTarget().func_145782_y())) {
            if (event.isCancelable()) {
                event.setCanceled(true);
            } else {
                event.getEntityLiving().func_230246_e_(null);
                event.getEntityLiving().func_130011_c(null);
                event.getEntityLiving().func_70604_c(null);
            }
        }
    }
}

