/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xreliquary.crafting.FragmentRecipeHelper;

public class FragmentToSpawnEggRecipe
extends ShapelessRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final ShapelessRecipe recipeDelegate;

    public FragmentToSpawnEggRecipe(ShapelessRecipe recipeDelegate) {
        super(recipeDelegate.func_199560_c(), recipeDelegate.func_193358_e(), recipeDelegate.func_77571_b(), recipeDelegate.func_192400_c());
        this.recipeDelegate = recipeDelegate;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        return super.func_77569_a(inv, worldIn) && FragmentRecipeHelper.hasOnlyOneFragmentType(inv);
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        return FragmentRecipeHelper.getRegistryName(inv).map(FragmentRecipeHelper::getSpawnEggStack).orElse(new ItemStack((IItemProvider)FragmentRecipeHelper.FALL_BACK_SPAWN_EGG));
    }

    public boolean func_192399_d() {
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<FragmentToSpawnEggRecipe> {
        public FragmentToSpawnEggRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new FragmentToSpawnEggRecipe((ShapelessRecipe)IRecipeSerializer.field_222158_b.func_199425_a_(recipeId, json));
        }

        @Nullable
        public FragmentToSpawnEggRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new FragmentToSpawnEggRecipe((ShapelessRecipe)IRecipeSerializer.field_222158_b.func_199426_a_(recipeId, buffer));
        }

        public void write(PacketBuffer buffer, FragmentToSpawnEggRecipe recipe) {
            IRecipeSerializer.field_222158_b.func_199427_a_(buffer, (IRecipe)recipe.recipeDelegate);
        }
    }
}

