/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import xreliquary.client.gui.GuiBase;
import xreliquary.common.gui.ContainerMobCharmBelt;
import xreliquary.init.ModItems;
import xreliquary.items.MobCharmBeltItem;
import xreliquary.items.MobCharmRegistry;
import xreliquary.util.LogHelper;

public class MobCharmBeltGui
extends GuiBase<ContainerMobCharmBelt> {
    private static final ResourceLocation BELT_TEX = new ResourceLocation("xreliquary", "textures/gui/mob_charm_belt.png");
    private static final ResourceLocation BELT_ITEM_TEX = new ResourceLocation("xreliquary", "textures/item/mob_charm_belt.png");
    private static final int WIDTH = 175;
    private static final int HEIGHT = 221;
    private final ItemStack belt;
    private static final Field SLOT_X_POS = ObfuscationReflectionHelper.findField(Slot.class, (String)"field_75223_e");
    private static final Field SLOT_Y_POS = ObfuscationReflectionHelper.findField(Slot.class, (String)"field_75221_f");

    public MobCharmBeltGui(ContainerMobCharmBelt container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.belt = container.getBelt();
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.bindTexture(BELT_TEX);
        GuiUtils.drawTexturedModalRect((MatrixStack)matrixStack, (int)i, (int)(j - 27), (int)0, (int)0, (int)175, (int)221, (float)0.0f);
        int centerX = i + 88;
        int centerY = j + 40;
        this.updateMobCharmSlots(matrixStack, centerX, centerY);
        this.bindTexture(BELT_ITEM_TEX);
        GlStateManager.func_227740_m_();
        MobCharmBeltGui.func_238463_a_((MatrixStack)matrixStack, (int)(centerX - 26), (int)(centerY - 26), (float)0.0f, (float)0.0f, (int)48, (int)48, (int)48, (int)48);
        GlStateManager.func_227737_l_();
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
    }

    private void updateMobCharmSlots(MatrixStack matrixStack, int centerX, int centerY) {
        int i;
        int slots = ((MobCharmBeltItem)ModItems.MOB_CHARM_BELT.get()).getCharmCount(this.belt);
        slots = Math.min(slots, MobCharmRegistry.getRegisteredNames().size());
        double radius = 44.0;
        double increment = Math.PI * 2 / (double)(slots + 1);
        double start = 1.5707963267948966;
        for (i = 1; i <= slots; ++i) {
            double angle = start + (double)i * increment;
            int offsetX = (int)Math.round(Math.cos(angle) * radius);
            int offsetY = (int)Math.round(Math.sin(angle) * radius);
            int x = centerX - offsetX - 8;
            int y = centerY - offsetY - 8;
            RenderSystem.enableAlphaTest();
            RenderSystem.enableBlend();
            this.func_238474_b_(matrixStack, x, y, 176, 0, 16, 16);
            RenderSystem.disableAlphaTest();
            RenderSystem.disableBlend();
            MobCharmBeltGui.setSlotXPos((Slot)((ContainerMobCharmBelt)this.field_147002_h).field_75151_b.get(i - 1), x - centerX + 88);
            MobCharmBeltGui.setSlotYPos((Slot)((ContainerMobCharmBelt)this.field_147002_h).field_75151_b.get(i - 1), y - centerY + 40);
        }
        MobCharmBeltGui.setSlotXPos((Slot)((ContainerMobCharmBelt)this.field_147002_h).field_75151_b.get(slots), 80);
        MobCharmBeltGui.setSlotYPos((Slot)((ContainerMobCharmBelt)this.field_147002_h).field_75151_b.get(slots), -12);
        for (i = slots + 1; i < MobCharmRegistry.getRegisteredNames().size() + 1; ++i) {
            MobCharmBeltGui.setSlotXPos((Slot)((ContainerMobCharmBelt)this.field_147002_h).field_75151_b.get(i), -999);
        }
    }

    private static void setSlotXPos(Slot slot, int xPos) {
        try {
            SLOT_X_POS.set(slot, xPos);
        }
        catch (IllegalAccessException e) {
            LogHelper.error("Error setting xPos of Slot: ", e);
        }
    }

    private static void setSlotYPos(Slot slot, int yPos) {
        try {
            SLOT_Y_POS.set(slot, yPos);
        }
        catch (IllegalAccessException e) {
            LogHelper.error("Error setting yPos of Slot: ", e);
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }
}

