/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster;

import appeng.api.util.AEPartLocation;
import appeng.core.AELog;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import java.lang.ref.WeakReference;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class MBCalculator<TTile extends IAEMultiBlock<TCluster>, TCluster extends IAECluster> {
    private static WeakReference<IAECluster> modificationInProgress = new WeakReference<Object>(null);
    protected final TTile target;

    public MBCalculator(TTile t) {
        this.target = t;
    }

    public static void setModificationInProgress(IAECluster cluster) {
        IAECluster inProgress = (IAECluster)modificationInProgress.get();
        if (inProgress == cluster) {
            return;
        }
        if (inProgress != null && cluster != null) {
            throw new IllegalStateException("A modification is already in-progress for: " + inProgress);
        }
        modificationInProgress = new WeakReference<IAECluster>(cluster);
    }

    public static boolean isModificationInProgress() {
        return modificationInProgress.get() != null;
    }

    public void updateMultiblockAfterNeighborUpdate(World world, BlockPos loc, BlockPos changedPos) {
        Object cluster = this.target.getCluster();
        boolean recheck = cluster != null ? (MBCalculator.isWithinBounds(changedPos, cluster.getBoundsMin(), cluster.getBoundsMax()) ? true : this.isValidTileAt(world, changedPos.func_177958_n(), changedPos.func_177956_o(), changedPos.func_177952_p())) : true;
        if (recheck) {
            this.calculateMultiblock(world, loc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateMultiblock(World world, BlockPos loc) {
        block20: {
            if (world.func_201670_d() || MBCalculator.isModificationInProgress()) {
                return;
            }
            Object currentCluster = this.target.getCluster();
            if (currentCluster != null && currentCluster.isDestroyed()) {
                return;
            }
            try {
                BlockPos.Mutable min = loc.func_239590_i_();
                BlockPos.Mutable max = loc.func_239590_i_();
                while (this.isValidTileAt(world, min.func_177958_n() - 1, min.func_177956_o(), min.func_177952_p())) {
                    min.func_223471_o(min.func_177958_n() - 1);
                }
                while (this.isValidTileAt(world, min.func_177958_n(), min.func_177956_o() - 1, min.func_177952_p())) {
                    min.func_185336_p(min.func_177956_o() - 1);
                }
                while (this.isValidTileAt(world, min.func_177958_n(), min.func_177956_o(), min.func_177952_p() - 1)) {
                    min.func_223472_q(min.func_177952_p() - 1);
                }
                while (this.isValidTileAt(world, max.func_177958_n() + 1, max.func_177956_o(), max.func_177952_p())) {
                    max.func_223471_o(max.func_177958_n() + 1);
                }
                while (this.isValidTileAt(world, max.func_177958_n(), max.func_177956_o() + 1, max.func_177952_p())) {
                    max.func_185336_p(max.func_177956_o() + 1);
                }
                while (this.isValidTileAt(world, max.func_177958_n(), max.func_177956_o(), max.func_177952_p() + 1)) {
                    max.func_223472_q(max.func_177952_p() + 1);
                }
                if (!this.checkMultiblockScale((BlockPos)min, (BlockPos)max) || !this.verifyUnownedRegion(world, (BlockPos)min, (BlockPos)max)) break block20;
                try {
                    if (!this.verifyInternalStructure(world, (BlockPos)min, (BlockPos)max)) {
                        this.disconnect();
                        return;
                    }
                }
                catch (Exception err) {
                    this.disconnect();
                    return;
                }
                boolean updateGrid = false;
                Object cluster = this.target.getCluster();
                if (cluster == null || !cluster.getBoundsMin().equals((Object)min) || !cluster.getBoundsMax().equals((Object)max)) {
                    cluster = this.createCluster(world, (BlockPos)min, (BlockPos)max);
                    MBCalculator.setModificationInProgress(cluster);
                    this.updateTiles(cluster, world, (BlockPos)min, (BlockPos)max);
                    updateGrid = true;
                } else {
                    MBCalculator.setModificationInProgress(cluster);
                }
                cluster.updateStatus(updateGrid);
                return;
            }
            catch (Throwable err) {
                AELog.debug(err);
            }
            finally {
                MBCalculator.setModificationInProgress(null);
            }
        }
        this.disconnect();
    }

    private static boolean isWithinBounds(BlockPos pos, BlockPos boundsMin, BlockPos boundsMax) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return x >= boundsMin.func_177958_n() && y >= boundsMin.func_177956_o() && z >= boundsMin.func_177952_p() && x <= boundsMax.func_177958_n() && y <= boundsMax.func_177956_o() && z <= boundsMax.func_177952_p();
    }

    private boolean isValidTileAt(World w, int x, int y, int z) {
        return this.isValidTile(w.func_175625_s(new BlockPos(x, y, z)));
    }

    public abstract boolean checkMultiblockScale(BlockPos var1, BlockPos var2);

    private boolean verifyUnownedRegion(World w, BlockPos min, BlockPos max) {
        for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
            if (!this.verifyUnownedRegionInner(w, min.func_177958_n(), min.func_177956_o(), min.func_177952_p(), max.func_177958_n(), max.func_177956_o(), max.func_177952_p(), side)) continue;
            return false;
        }
        return true;
    }

    public abstract TCluster createCluster(World var1, BlockPos var2, BlockPos var3);

    public abstract boolean verifyInternalStructure(World var1, BlockPos var2, BlockPos var3);

    public void disconnect() {
        this.target.disconnect(true);
    }

    public abstract void updateTiles(TCluster var1, World var2, BlockPos var3, BlockPos var4);

    public abstract boolean isValidTile(TileEntity var1);

    private boolean verifyUnownedRegionInner(World w, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, AEPartLocation side) {
        switch (side) {
            case WEST: {
                maxX = --minX;
                break;
            }
            case EAST: {
                minX = ++maxX;
                break;
            }
            case DOWN: {
                maxY = --minY;
                break;
            }
            case NORTH: {
                minZ = ++maxZ;
                break;
            }
            case SOUTH: {
                maxZ = --minZ;
                break;
            }
            case UP: {
                minY = ++maxY;
                break;
            }
            case INTERNAL: {
                return false;
            }
        }
        for (BlockPos p : BlockPos.func_191531_b((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
            TileEntity te = w.func_175625_s(p);
            if (!this.isValidTile(te)) continue;
            return true;
        }
        return false;
    }
}

