/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.events.statistics.MENetworkChunkEvent;
import appeng.api.util.DimensionalCoord;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public class StatisticsCache
implements IGridCache {
    private IGrid grid;
    private Map<IWorld, Multiset<ChunkPos>> chunks;

    public StatisticsCache(IGrid g) {
        this.grid = g;
        this.chunks = new HashMap<IWorld, Multiset<ChunkPos>>();
    }

    @Override
    public void onUpdateTick() {
    }

    @Override
    public void removeNode(IGridNode node, IGridHost machine) {
        if (node.getGridBlock().isWorldAccessible()) {
            DimensionalCoord loc = node.getGridBlock().getLocation();
            this.removeChunk((IWorld)loc.getWorld(), loc.getBlockPos());
        }
    }

    @Override
    public void addNode(IGridNode node, IGridHost machine) {
        if (node.getGridBlock().isWorldAccessible()) {
            DimensionalCoord loc = node.getGridBlock().getLocation();
            this.addChunk((IWorld)loc.getWorld(), loc.getBlockPos());
        }
    }

    @Override
    public void onSplit(IGridStorage storageB) {
    }

    @Override
    public void onJoin(IGridStorage storageB) {
    }

    @Override
    public void populateGridStorage(IGridStorage storage) {
    }

    public IGrid getGrid() {
        return this.grid;
    }

    public Set<IWorld> worlds() {
        return this.chunks.keySet();
    }

    public Set<ChunkPos> chunks(IWorld world) {
        return this.chunks.get(world).elementSet();
    }

    public Map<IWorld, Multiset<ChunkPos>> getChunks() {
        return this.chunks;
    }

    private boolean addChunk(IWorld world, BlockPos pos) {
        ChunkPos position = new ChunkPos(pos);
        if (!this.getChunks(world).contains((Object)position)) {
            this.grid.postEvent(new MENetworkChunkEvent.MENetworkChunkAdded((ServerWorld)world, position));
        }
        return this.getChunks(world).add((Object)position);
    }

    private boolean removeChunk(IWorld world, BlockPos pos) {
        ChunkPos position = new ChunkPos(pos);
        boolean ret = this.getChunks(world).remove((Object)position);
        if (ret && !this.getChunks(world).contains((Object)position)) {
            this.grid.postEvent(new MENetworkChunkEvent.MENetworkChunkRemoved((ServerWorld)world, position));
        }
        this.clearWorld(world);
        return ret;
    }

    private Multiset<ChunkPos> getChunks(IWorld world) {
        return this.chunks.computeIfAbsent(world, w -> HashMultiset.create());
    }

    private void clearWorld(IWorld world) {
        if (this.chunks.get(world).isEmpty()) {
            this.chunks.remove(world);
        }
    }
}

