/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum LinuxProc {
    CPUINFO("/proc/cpuinfo"),
    MEMINFO("/proc/meminfo"),
    NET_DEV("/proc/net/dev");

    private final Path path;

    private LinuxProc(String path) {
        this.path = LinuxProc.resolvePath(path);
    }

    private static @Nullable Path resolvePath(String path) {
        try {
            Path p = Paths.get(path, new String[0]);
            if (Files.isReadable(p)) {
                return p;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public @NonNull List<String> read() {
        if (this.path != null) {
            try {
                return Files.readAllLines(this.path, StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }
}

