/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakedmodels;

import codechicken.lib.model.CachedFormat;
import codechicken.lib.model.bakedmodels.ModelProperties;
import codechicken.lib.render.particle.IModelParticleProvider;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.LightUtil;

public abstract class AbstractBakedPropertiesModel
implements IModelParticleProvider,
IBakedModel {
    protected final ModelProperties properties;

    public AbstractBakedPropertiesModel(ModelProperties properties) {
        this.properties = properties;
    }

    public boolean func_177555_b() {
        return this.properties.isAmbientOcclusion();
    }

    public boolean func_177556_c() {
        return this.properties.isGui3d();
    }

    public boolean func_188618_c() {
        return this.properties.isBuiltInRenderer();
    }

    public boolean func_230044_c_() {
        return this.properties.usesBlockLight();
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return this.properties.getParticleTexture();
    }

    protected List<BakedQuad> getAllQuads(BlockState state, IModelData modelData) {
        LinkedList<BakedQuad> allQuads = new LinkedList<BakedQuad>();
        allQuads.addAll(this.getQuads(state, null, new Random(0L), modelData));
        for (Direction face : Direction.field_82609_l) {
            allQuads.addAll(this.getQuads(state, face, new Random(0L), modelData));
        }
        return allQuads;
    }

    @Override
    public Set<TextureAtlasSprite> getHitEffects(@Nonnull BlockRayTraceResult traceResult, BlockState state, IBlockReader world, BlockPos pos, IModelData modelData) {
        Vector3 vec = new Vector3(traceResult.func_216347_e()).subtract(traceResult.func_216350_a());
        return this.getAllQuads(state, modelData).stream().filter(quad -> quad.func_178210_d() == traceResult.func_216354_b()).filter(quad -> this.checkDepth((BakedQuad)quad, vec, traceResult.func_216354_b())).map(BakedQuad::func_187508_a).collect(Collectors.toSet());
    }

    protected boolean checkDepth(BakedQuad quad, Vector3 hit, Direction hitFace) {
        int[] quadData = quad.func_178209_a();
        CachedFormat format = CachedFormat.lookup(DefaultVertexFormats.field_176600_a);
        Vector3 posVec = new Vector3();
        float[] pos = new float[4];
        for (int v = 0; v < 4; ++v) {
            LightUtil.unpack((int[])quadData, (float[])pos, (VertexFormat)format.format, (int)v, (int)format.positionIndex);
            posVec.add(pos[0], pos[1], pos[2]);
        }
        posVec.divide(4.0);
        double diff = 0.0;
        switch (hitFace.func_176740_k()) {
            case X: {
                diff = Math.abs(hit.x - posVec.x);
                break;
            }
            case Y: {
                diff = Math.abs(hit.y - posVec.y);
                break;
            }
            case Z: {
                diff = Math.abs(hit.z - posVec.z);
            }
        }
        return !(diff > 0.01);
    }

    @Override
    public Set<TextureAtlasSprite> getDestroyEffects(BlockState state, IBlockReader world, BlockPos pos, IModelData data) {
        return this.getAllQuads(state, data).stream().map(BakedQuad::func_187508_a).collect(Collectors.toSet());
    }

    public boolean doesHandlePerspectives() {
        return true;
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType transformType, MatrixStack mat) {
        if (this.properties instanceof ModelProperties.PerspectiveProperties) {
            IModelTransform transforms = ((ModelProperties.PerspectiveProperties)this.properties).getTransforms();
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (IModelTransform)transforms, (ItemCameraTransforms.TransformType)transformType, (MatrixStack)mat);
        }
        return IModelParticleProvider.super.handlePerspective(transformType, mat);
    }
}

