/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.rechiseled_compat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipes;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mrthomas20121.rechiseled_compat.RechiseledCompat;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="rechiseled_compat")
public class CustomChiselingRecipeLoader
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAddReloadListener(AddReloadListenerEvent e) {
        e.addListener((IFutureReloadListener)new CustomChiselingRecipeLoader());
    }

    public CustomChiselingRecipeLoader() {
        super(GSON, "custom_chiseling_recipes");
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> entries, @Nonnull IResourceManager resourceManager, @Nonnull IProfiler profilerFiller) {
        ArrayList<ChiselingRecipe> recipes = new ArrayList<ChiselingRecipe>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : entries.entrySet()) {
            JsonObject object = entry.getValue().getAsJsonObject();
            if (!object.has("mod_id") || !ModList.get().isLoaded(object.get("mod_id").getAsString())) continue;
            recipes.add(ChiselingRecipe.Serializer.fromJson((ResourceLocation)entry.getKey(), (JsonObject)object));
        }
        recipes.addAll(ChiselingRecipes.getAllRecipes());
        try {
            Method method = ChiselingRecipes.class.getDeclaredMethod("setRecipes", List.class);
            method.setAccessible(true);
            method.invoke(ChiselingRecipe.class, recipes);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            RechiseledCompat.LOGGER.error((Object)e);
        }
    }
}

