/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.AbstractButtonWidget;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class PreviewModeButtonWidget
extends AbstractButtonWidget {
    private static final ResourceLocation GREY_BUTTONS = new ResourceLocation("rechiseled", "textures/screen/grey_buttons.png");
    private static final ResourceLocation[][] ICONS = new ResourceLocation[][]{{new ResourceLocation("rechiseled", "textures/screen/icon_1x1.png"), new ResourceLocation("rechiseled", "textures/screen/icon_1x1_grey.png")}, {new ResourceLocation("rechiseled", "textures/screen/icon_3x1.png"), new ResourceLocation("rechiseled", "textures/screen/icon_3x1_grey.png")}, {new ResourceLocation("rechiseled", "textures/screen/icon_3x3.png"), new ResourceLocation("rechiseled", "textures/screen/icon_3x3_grey.png")}};
    private final int mode;
    private final Supplier<Integer> currentMode;
    private final Supplier<Boolean> enabled;

    public PreviewModeButtonWidget(int x, int y, int width, int height, int mode, Supplier<Integer> currentMode, Supplier<Boolean> enabled, Runnable onPress) {
        super(x, y, width, height, onPress);
        this.mode = mode;
        this.currentMode = currentMode;
        this.enabled = enabled;
    }

    protected ITextComponent getNarrationMessage() {
        return TextComponents.translation((String)"rechiseled.chiseling.preview").get();
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int currentMode = this.currentMode.get();
        boolean selected = this.mode == currentMode;
        boolean enabled = this.enabled.get();
        ScreenUtils.bindTexture((ResourceLocation)GREY_BUTTONS);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)0.0f, (float)((float)(!enabled || selected ? 1 : (this.hovered ? 2 : 0)) / 3.0f), (float)1.0f, (float)0.33333334f);
        GlStateManager.func_227709_e_();
        ScreenUtils.bindTexture((ResourceLocation)ICONS[this.mode][selected ? 1 : 0]);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)(this.x + 1), (float)(this.y + 2), (float)(this.width - 2), (float)(this.height - 4));
    }
}

