/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.screen.BlockCapture;
import com.supermartijn642.rechiseled.screen.ScreenBlockRenderer;
import com.supermartijn642.rechiseled.screen.ScreenItemRender;
import java.util.function.Supplier;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class EntryButtonWidget
extends Widget {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rechiseled", "textures/screen/buttons.png");
    private final Supplier<ChiselingEntry> entry;
    private final Supplier<ChiselingEntry> selectedEntry;
    private final Runnable onClick;
    private final Supplier<Boolean> connecting;
    private final Supplier<Integer> guiLeft;
    private final Supplier<Integer> guiTop;

    public EntryButtonWidget(int x, int y, int width, int height, Supplier<ChiselingEntry> entrySupplier, Supplier<ChiselingEntry> selectedEntrySupplier, Runnable onClick, Supplier<Boolean> connecting, Supplier<Integer> guiLeft, Supplier<Integer> guiTop) {
        super(x, y, width, height);
        this.entry = entrySupplier;
        this.selectedEntry = selectedEntrySupplier;
        this.onClick = onClick;
        this.connecting = connecting;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
    }

    protected ITextComponent getNarrationMessage() {
        ChiselingEntry entry = this.entry.get();
        if (entry == null) {
            return null;
        }
        Item item = this.connecting.get() != false && entry.hasConnectingItem() || !entry.hasRegularItem() ? entry.getConnectingItem() : entry.getRegularItem();
        return TextComponents.translation((String)"rechiseled.chiseling.select_block", (Object[])new Object[]{TextComponents.item((Item)item).get()}).get();
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        boolean selected;
        ChiselingEntry entry = this.entry.get();
        boolean hasEntry = entry != null;
        boolean bl = selected = hasEntry && this.selectedEntry.get() == entry;
        boolean hasCorrectItem = hasEntry && (this.connecting.get() != false ? entry.hasConnectingItem() : entry.hasRegularItem());
        ScreenUtils.bindTexture((ResourceLocation)TEXTURE);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)0.0f, (float)((float)(selected ? 1 : (hasEntry ? (hasCorrectItem ? (this.hovered ? 2 : 0) : (this.hovered ? 4 : 3)) : 0)) / 5.0f), (float)1.0f, (float)0.2f);
        if (hasEntry) {
            Item item;
            Item item2 = item = this.connecting.get() != false && entry.hasConnectingItem() || !entry.hasRegularItem() ? entry.getConnectingItem() : entry.getRegularItem();
            if (item instanceof BlockItem) {
                BlockCapture capture = new BlockCapture(((BlockItem)item).func_179223_d());
                ScreenBlockRenderer.drawBlock(capture, (double)(this.guiLeft.get() + this.x) + (double)this.width / 2.0, (double)(this.guiTop.get() + this.y) + (double)this.height / 2.0, this.width, 135.0f, 40.0f, true);
            } else {
                ScreenItemRender.drawItem(item, (double)(this.guiLeft.get() + this.x) + (double)this.width / 2.0, (double)(this.guiTop.get() + this.y) + (double)this.height / 2.0, (double)(this.width - 4) * 1.416, 0.0f, 0.0f, false);
            }
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int button) {
        ChiselingEntry entry;
        if (mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height && (entry = this.entry.get()) != null) {
            this.onClick.run();
        }
    }
}

