/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipes;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public abstract class BaseChiselingContainer
extends BaseContainer {
    public ChiselingRecipe currentRecipe = null;
    public ChiselingEntry currentEntry = null;
    public boolean connecting = false;

    public BaseChiselingContainer(ContainerType<?> type, int id, PlayerEntity player) {
        super(type, id, player);
        this.addSlots();
    }

    protected void addSlots(PlayerEntity playerEntity) {
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)new IItemHandlerModifiable(){

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    BaseChiselingContainer.this.setCurrentStack(stack);
                    BaseChiselingContainer.this.updateRecipe();
                }
            }

            public int getSlots() {
                return 1;
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return slot == 0 ? BaseChiselingContainer.this.getCurrentStack() : ItemStack.field_190927_a;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (slot != 0 || stack.func_190926_b()) {
                    return stack.func_77946_l();
                }
                ItemStack currentStack = BaseChiselingContainer.this.getCurrentStack();
                if (!currentStack.func_190926_b() && !ItemStack.func_77989_b((ItemStack)currentStack, (ItemStack)stack)) {
                    return stack.func_77946_l();
                }
                int count = Math.min(stack.func_190916_E(), stack.func_77976_d() - currentStack.func_190916_E());
                if (!simulate) {
                    ItemStack newStack = stack.func_77946_l();
                    newStack.func_190920_e(currentStack.func_190916_E() + count);
                    BaseChiselingContainer.this.setCurrentStack(newStack);
                }
                stack = stack.func_77946_l();
                stack.func_190918_g(count);
                return stack;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot != 0 || amount <= 0) {
                    return ItemStack.field_190927_a;
                }
                ItemStack currentStack = BaseChiselingContainer.this.getCurrentStack();
                int count = Math.min(amount, currentStack.func_190916_E());
                if (!simulate) {
                    ItemStack newStack = currentStack.func_77946_l();
                    newStack.func_190918_g(count);
                    BaseChiselingContainer.this.setCurrentStack(newStack);
                    BaseChiselingContainer.this.updateRecipe();
                }
                currentStack = currentStack.func_77946_l();
                currentStack.func_190920_e(count);
                return currentStack;
            }

            public int getSlotLimit(int slot) {
                if (slot != 0) {
                    return 0;
                }
                ItemStack currentStack = BaseChiselingContainer.this.getCurrentStack();
                return currentStack.func_190926_b() ? 64 : currentStack.func_77976_d();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return slot == 0 && ChiselingRecipes.getRecipe(stack) != null;
            }
        }, 0, 154, 102));
        this.addPlayerSlots(31, 144);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return !this.shouldBeClosed();
    }

    protected void updateRecipe() {
        ItemStack stack = this.getCurrentStack();
        if (stack.func_190926_b()) {
            this.currentRecipe = null;
            this.currentEntry = null;
            this.connecting = false;
        } else {
            this.currentRecipe = ChiselingRecipes.getRecipe(stack);
            if (this.currentRecipe != null) {
                for (ChiselingEntry entry : this.currentRecipe.getEntries()) {
                    if (entry.hasRegularItem() && entry.getRegularItem() == stack.func_77973_b()) {
                        this.currentEntry = entry;
                        this.connecting = false;
                        return;
                    }
                    if (!entry.hasConnectingItem() || entry.getConnectingItem() != stack.func_77973_b()) continue;
                    this.currentEntry = entry;
                    this.connecting = true;
                    return;
                }
            } else {
                this.currentEntry = null;
                this.connecting = false;
            }
        }
    }

    public void setCurrentEntry(int index) {
        if (this.currentRecipe == null || index >= this.currentRecipe.getEntries().size()) {
            return;
        }
        ChiselingEntry entry = this.currentRecipe.getEntries().get(index);
        Item item = this.connecting && entry.hasConnectingItem() || !entry.hasRegularItem() ? entry.getConnectingItem() : entry.getRegularItem();
        ItemStack stack = new ItemStack((IItemProvider)item, this.getCurrentStack().func_190916_E());
        this.setCurrentStack(stack);
        this.updateRecipe();
    }

    public void toggleConnecting() {
        if (this.currentRecipe == null) {
            return;
        }
        if (this.connecting) {
            if (this.currentEntry.hasRegularItem()) {
                ItemStack stack = new ItemStack((IItemProvider)this.currentEntry.getRegularItem(), this.getCurrentStack().func_190916_E());
                this.setCurrentStack(stack);
                this.updateRecipe();
            }
        } else if (this.currentEntry.hasConnectingItem()) {
            ItemStack stack = new ItemStack((IItemProvider)this.currentEntry.getConnectingItem(), this.getCurrentStack().func_190916_E());
            this.setCurrentStack(stack);
            this.updateRecipe();
        }
    }

    public void chiselAll() {
        if (this.currentRecipe == null) {
            return;
        }
        PlayerInventory inventory = this.player.field_71071_by;
        for (int index = 0; index < inventory.func_70302_i_(); ++index) {
            Item item;
            ItemStack stack = inventory.func_70301_a(index);
            Item item2 = item = this.connecting ? this.currentEntry.getConnectingItem() : this.currentEntry.getRegularItem();
            if (stack.func_190916_E() > item.func_77639_j()) continue;
            for (ChiselingEntry entry : this.currentRecipe.getEntries()) {
                if (stack.func_77942_o() && !stack.func_77978_p().isEmpty() || (!entry.hasConnectingItem() || stack.func_77973_b() != entry.getConnectingItem()) && (!entry.hasRegularItem() || stack.func_77973_b() != entry.getRegularItem())) continue;
                stack = new ItemStack((IItemProvider)item, stack.func_190916_E());
                inventory.func_70299_a(index, stack);
            }
        }
    }

    public abstract ItemStack getCurrentStack();

    public abstract void setCurrentStack(ItemStack var1);

    public abstract boolean shouldBeClosed();

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack stack = this.func_75139_a(index).func_75211_c();
        if (stack.func_190926_b()) {
            return stack;
        }
        if (index == 0 ? !this.func_75135_a(stack, 1, this.field_75151_b.size(), true) : !this.func_75135_a(stack, 0, 1, true)) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190926_b()) {
            ((Slot)this.field_75151_b.get(index)).func_75215_d(stack);
        }
        return stack;
    }

    protected boolean func_75135_a(ItemStack stack, int minSlot, int maxSlot, boolean reversed) {
        ItemStack slotStack;
        Slot slot;
        boolean changed = false;
        int index = minSlot;
        if (reversed) {
            index = maxSlot - 1;
        }
        if (stack.func_77985_e()) {
            while (!stack.func_190926_b() && !(!reversed ? index >= maxSlot : index < minSlot)) {
                slot = (Slot)this.field_75151_b.get(index);
                slotStack = slot.func_75211_c();
                if (!slotStack.func_190926_b() && BaseChiselingContainer.func_195929_a((ItemStack)stack, (ItemStack)slotStack)) {
                    int maxSize;
                    int sumCount = slotStack.func_190916_E() + stack.func_190916_E();
                    if (sumCount <= (maxSize = Math.min(slot.func_75219_a(), stack.func_77976_d()))) {
                        stack.func_190920_e(0);
                        slotStack.func_190920_e(sumCount);
                        slot.func_75215_d(slotStack);
                        changed = true;
                    } else if (slotStack.func_190916_E() < maxSize) {
                        stack.func_190918_g(maxSize - slotStack.func_190916_E());
                        slotStack.func_190920_e(maxSize);
                        slot.func_75215_d(slotStack);
                        changed = true;
                    }
                }
                if (reversed) {
                    --index;
                    continue;
                }
                ++index;
            }
        }
        if (!stack.func_190926_b()) {
            index = reversed ? maxSlot - 1 : minSlot;
            while (!(!reversed ? index >= maxSlot : index < minSlot)) {
                slot = (Slot)this.field_75151_b.get(index);
                slotStack = slot.func_75211_c();
                if (slotStack.func_190926_b() && slot.func_75214_a(stack)) {
                    if (stack.func_190916_E() > slot.func_75219_a()) {
                        slot.func_75215_d(stack.func_77979_a(slot.func_75219_a()));
                    } else {
                        slot.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
                    }
                    changed = true;
                    break;
                }
                if (reversed) {
                    --index;
                    continue;
                }
                ++index;
            }
        }
        return changed;
    }
}

