/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.model;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.supermartijn642.rechiseled.model.RechiseledBakedModel;
import com.supermartijn642.rechiseled.model.RechiseledConnectedBakedModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class RechiseledModel
implements IModelGeometry<RechiseledModel> {
    private final boolean shouldConnect;
    private final ResourceLocation parent;
    private final List<BlockPart> elements;
    private final Map<String, Either<Pair<RenderMaterial, Boolean>, String>> textureMap;
    private final boolean ambientOcclusion;
    private final BlockModel.GuiLight guiLight;
    private final ItemCameraTransforms cameraTransforms;
    private final List<ItemOverride> itemOverrides;

    public RechiseledModel(boolean shouldConnect, ResourceLocation parent, List<BlockPart> elements, Map<String, Either<Pair<RenderMaterial, Boolean>, String>> textureMap, boolean ambientOcclusion, BlockModel.GuiLight guiLight, ItemCameraTransforms cameraTransforms, List<ItemOverride> itemOverrides) {
        this.shouldConnect = shouldConnect;
        this.parent = parent;
        this.elements = elements;
        this.textureMap = textureMap;
        this.ambientOcclusion = ambientOcclusion;
        this.guiLight = guiLight;
        this.cameraTransforms = cameraTransforms;
        this.itemOverrides = itemOverrides;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        Function<ResourceLocation, IUnbakedModel> modelGetter = arg_0 -> ((ModelBakery)bakery).func_209597_a(arg_0);
        TextureAtlasSprite particle = spriteGetter.apply((RenderMaterial)this.getTexture("particle", modelGetter).getFirst());
        List<BlockPart> elements = this.getElements(modelGetter);
        ItemCameraTransforms transforms = this.getTransforms(modelGetter);
        EnumMap quads = Maps.newEnumMap(Direction.class);
        for (BlockPart part : elements) {
            for (Direction direction : part.field_178240_c.keySet()) {
                BlockPartFace face = (BlockPartFace)part.field_178240_c.get(direction);
                Pair<RenderMaterial, Boolean> texture = this.getTexture(face.field_178242_d, modelGetter);
                TextureAtlasSprite sprite = spriteGetter.apply((RenderMaterial)texture.getFirst());
                boolean connecting = (Boolean)texture.getSecond();
                BakedQuad quad = BlockModel.makeBakedQuad((BlockPart)part, (BlockPartFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (IModelTransform)modelTransform, (ResourceLocation)modelLocation);
                Direction cullFace = face.field_178244_b == null ? null : Direction.func_229385_a_((Matrix4f)modelTransform.func_225615_b_().func_227988_c_(), (Direction)face.field_178244_b);
                quads.putIfAbsent(cullFace, new ArrayList());
                ((List)quads.get(cullFace)).add(new Tuple((Object)quad, (Object)connecting));
            }
        }
        return this.shouldConnect ? new RechiseledConnectedBakedModel(quads, owner.useSmoothLighting(), owner.isShadedInGui(), owner.isSideLit(), false, particle, overrides, transforms) : new RechiseledBakedModel(quads, owner.useSmoothLighting(), owner.isShadedInGui(), owner.isSideLit(), false, particle, overrides, transforms);
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet textures = Sets.newHashSet();
        RenderMaterial particles = (RenderMaterial)this.getTexture("particle", modelGetter).getFirst();
        if (Objects.equals(particles.func_229313_b_(), MissingTextureSprite.func_195675_b())) {
            missingTextureErrors.add((Pair<String, String>)Pair.of((Object)"particle", (Object)owner.getModelName()));
        }
        for (BlockPart part : this.getElements(modelGetter)) {
            for (BlockPartFace face : part.field_178240_c.values()) {
                RenderMaterial texture = (RenderMaterial)this.getTexture(face.field_178242_d, modelGetter).getFirst();
                if (Objects.equals(texture.func_229313_b_(), MissingTextureSprite.func_195675_b())) {
                    missingTextureErrors.add((Pair<String, String>)Pair.of((Object)face.field_178242_d, (Object)owner.getModelName()));
                }
                textures.add(texture);
            }
        }
        return textures;
    }

    private Pair<RenderMaterial, Boolean> getTexture(String texture, Function<ResourceLocation, IUnbakedModel> modelGetter) {
        if (texture.charAt(0) == '#') {
            texture = texture.substring(1);
        }
        ArrayList list = Lists.newArrayList();
        Either<Pair<RenderMaterial, Boolean>, String> either;
        Optional optional;
        while (!(optional = (either = this.findTextureEntry(texture, modelGetter)).left()).isPresent()) {
            texture = (String)either.right().get();
            if (list.contains(texture)) {
                System.err.printf("Unable to resolve texture due to reference chain %s->%s%n", Joiner.on((String)"->").join((Iterable)list), texture);
                return Pair.of((Object)new RenderMaterial(AtlasTexture.field_110575_b, MissingTextureSprite.func_195675_b()), (Object)false);
            }
            list.add(texture);
        }
        return (Pair)optional.get();
    }

    private Either<Pair<RenderMaterial, Boolean>, String> findTextureEntry(String texture, Function<ResourceLocation, IUnbakedModel> modelGetter) {
        IUnbakedModel parent;
        if (this.textureMap.containsKey(texture)) {
            return this.textureMap.get(texture);
        }
        IUnbakedModel iUnbakedModel = parent = this.parent == null ? null : modelGetter.apply(this.parent);
        if (parent instanceof BlockModel) {
            if (((BlockModel)parent).customData.hasCustomGeometry() && ((BlockModel)parent).customData.getCustomGeometry() instanceof RechiseledModel) {
                return ((RechiseledModel)((BlockModel)parent).customData.getCustomGeometry()).findTextureEntry(texture, modelGetter);
            }
            BlockModel blockmodel = (BlockModel)parent;
            while (blockmodel != null) {
                Either either = (Either)blockmodel.field_178318_c.get(texture);
                if (either != null) {
                    return either.mapLeft(material -> Pair.of((Object)material, (Object)false));
                }
                blockmodel = blockmodel.field_178315_d;
            }
        }
        return Either.left((Object)Pair.of((Object)new RenderMaterial(AtlasTexture.field_110575_b, MissingTextureSprite.func_195675_b()), (Object)false));
    }

    private List<BlockPart> getElements(Function<ResourceLocation, IUnbakedModel> modelGetter) {
        List<BlockPart> elements = this.elements;
        if (this.elements.isEmpty()) {
            IUnbakedModel parent;
            IUnbakedModel iUnbakedModel = parent = this.parent == null ? null : modelGetter.apply(this.parent);
            if (parent instanceof BlockModel) {
                elements = ((BlockModel)parent).customData.hasCustomGeometry() && ((BlockModel)parent).customData.getCustomGeometry() instanceof RechiseledModel ? ((RechiseledModel)((BlockModel)parent).customData.getCustomGeometry()).getElements(modelGetter) : ((BlockModel)parent).func_178298_a();
            }
        }
        return elements;
    }

    public ItemCameraTransforms getTransforms(Function<ResourceLocation, IUnbakedModel> modelGetter) {
        ItemTransformVec3f thirdPersonLeftHand = this.getTransform(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, modelGetter);
        ItemTransformVec3f thirdPersonRightHand = this.getTransform(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, modelGetter);
        ItemTransformVec3f firstPersonLeftHand = this.getTransform(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, modelGetter);
        ItemTransformVec3f firstPersonRightHand = this.getTransform(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, modelGetter);
        ItemTransformVec3f head = this.getTransform(ItemCameraTransforms.TransformType.HEAD, modelGetter);
        ItemTransformVec3f gui = this.getTransform(ItemCameraTransforms.TransformType.GUI, modelGetter);
        ItemTransformVec3f ground = this.getTransform(ItemCameraTransforms.TransformType.GROUND, modelGetter);
        ItemTransformVec3f fixed = this.getTransform(ItemCameraTransforms.TransformType.FIXED, modelGetter);
        return new ItemCameraTransforms(thirdPersonLeftHand, thirdPersonRightHand, firstPersonLeftHand, firstPersonRightHand, head, gui, ground, fixed);
    }

    private ItemTransformVec3f getTransform(ItemCameraTransforms.TransformType transformType, Function<ResourceLocation, IUnbakedModel> modelGetter) {
        IUnbakedModel parent;
        if (this.cameraTransforms.func_181687_c(transformType)) {
            return this.cameraTransforms.func_181688_b(transformType);
        }
        IUnbakedModel iUnbakedModel = parent = this.parent == null ? null : modelGetter.apply(this.parent);
        if (parent instanceof BlockModel) {
            if (((BlockModel)parent).customData.hasCustomGeometry() && ((BlockModel)parent).customData.getCustomGeometry() instanceof RechiseledModel) {
                return ((RechiseledModel)((BlockModel)parent).customData.getCustomGeometry()).getTransform(transformType, modelGetter);
            }
            return ((BlockModel)parent).func_181682_g().func_181688_b(transformType);
        }
        return this.cameraTransforms.func_181688_b(transformType);
    }
}

